//
//  BlankViewController.swift
//  BookCore
//
//  Created by 日々野清高 on 2023/01/23.
//

import Foundation
import UIKit
import SpriteKit
import PlaygroundSupport
import AVFoundation

public class BlankViewController: UIViewController,PlaygroundLiveViewSafeAreaContainer  {
    
    public required init(coder aDecoder: NSCoder) {
        super.init(coder: aDecoder)!
    }
    
    public override init(nibName nibNameOrNil: String?, bundle nibBundleOrNil: Bundle?) {
        super.init(nibName: nibNameOrNil, bundle: nibBundleOrNil)
    }

    override public func viewDidLoad() {
        super.viewDidLoad()
        
        let label = UILabel()
        label.frame = CGRect(x: 0, y : self.view.frame.height/2, width: self.view.frame.width, height: 150) //ラベルの位置とサイズ
        label.text = "（▶︎コードを実行）ボタンで実行しましょう。" // ラベルのテキスト
        label.textAlignment = NSTextAlignment.center
        self.view.addSubview(label)
        label.clipsToBounds = true //はみ出さない様にする。
        //mapView.backgroundColor  = #colorLiteral(red: 0, green: 0, blue: 0, alpha: 1)
        label.layer.cornerRadius = 10
        label.translatesAutoresizingMaskIntoConstraints  = false
        label.topAnchor.constraint(equalTo: liveViewSafeAreaGuide.topAnchor, constant: 40).isActive = true
        label.bottomAnchor.constraint(equalTo: liveViewSafeAreaGuide.bottomAnchor, constant: -40).isActive = true
        label.leadingAnchor.constraint(equalTo: liveViewSafeAreaGuide.leadingAnchor, constant: 20).isActive = true
        label.trailingAnchor.constraint(equalTo: liveViewSafeAreaGuide.trailingAnchor, constant: -20).isActive = true
    }
    
}
