//#-hidden-code
//
//  See LICENSE folder for this template’s licensing information.
//
//  Abstract:
//  The Swift file containing the source code edited by the user of this playground book.
//
import PlaygroundSupport
import UIKit

let page = PlaygroundPage.current
page.needsIndefiniteExecution = true
var cNumber = 1
let 🔳 = 0
let 🟥 = 1
let 🟩 = 2
let 🟦 = 3

var droped = [[0,0,0,0,0,0,0,0,0,0],
              [0,0,0,0,0,0,0,0,0,0],
              [0,0,0,0,0,0,0,0,0,0],
              [0,0,0,0,0,0,0,0,0,0],
              [0,0,0,0,0,0,0,0,0,0],
              [0,0,0,0,0,0,0,0,0,0],
              [0,0,0,0,0,0,0,0,0,0],
              [0,0,0,0,0,0,0,0,0,0],
              [0,0,0,0,0,0,0,0,0,0],
              [0,0,0,0,0,0,0,0,0,0]]

var counter = [0,0,0,0,0,0,0,0,0,0]
var topColor = [0,0,0,0,0,0,0,0,0,0]

func send(_ str: String) {
    if let proxy1 = page.liveView as? PlaygroundRemoteLiveViewProxy {
        let message: PlaygroundValue = .string(str)
        proxy1.send(message)
    }
}

func clear() {
    send("clear")
    send("color 1")
    cNumber = 1
    for i in 0 ... 9 {
        counter[i] = 0
        for j in 0 ... 9 {
            droped[i][j] = 0
        }
    }
}
func randomColor() {
    cNumber =  Int.random(in: 1..<4)
    color(cNumber)
}

func drop(_ x: Int) {
    if(x > 0 && x < 11) {
        Thread.sleep(forTimeInterval: 0.5)
        send("drop "+x.description)
        if(counter[x-1] < 10) {
           droped[9-counter[x-1]][x-1] = cNumber
           counter[x-1] = counter[x-1] + 1
           topColor[x-1] = cNumber
        }
    } else {
        PlaygroundPage.current.assessmentStatus = .fail(hints: ["drop()の引数に範囲外の値が指定されています。drop()の括弧内には1〜10の整数型(Int)の数値を入れてください。"], solution: nil)
    }
}

func color(_ t: Int) {
    if(t >= 0 && t < 4) {
        send("color "+t.description)
        cNumber = t
    } else {
        PlaygroundPage.current.assessmentStatus = .fail(hints: ["color()の引数に範囲外の値が指定されています。color()の括弧内には0〜3の整数型(Int)の数値を入れてください。"], solution: nil)
    }
}

func sendMessage(_ message: String) {
    send("message "+message)
}

func top(_ x: Int) -> Int {
    if(x > 0 && x < 11) {
        return topColor[x-1]
    } else {
        return 0
    }
}

func check() {
    var clear = true
    for i in 0 ... 9 {
        for j in 0 ... 9 {
            if(droped[i][j] != answer[i][j]) {
                clear = false
            }
        }
    }
    if (clear == true) {
        sendMessage("⑩-😄できました!")
        PlaygroundPage.current.assessmentStatus = .pass(message: "😃おみごと！クリアーです!🎉")
    } else {
        sendMessage("⑩-🥶うまくいきませんでした。")
        PlaygroundPage.current.assessmentStatus = .fail(hints: ["🤔ざんねん！宝石の「いち」と「いろ」をかくにんしてみましょう。"], solution: nil)
    }
}

var answer = [[🔳,🔳,🔳,🔳,🔳,🔳,🔳,🔳,🔳,🔳],
              [🔳,🔳,🔳,🔳,🔳,🔳,🔳,🔳,🔳,🔳],
              [🔳,🔳,🔳,🔳,🔳,🔳,🔳,🔳,🔳,🔳],
              [🔳,🔳,🔳,🔳,🔳,🔳,🔳,🔳,🔳,🟦],
              [🔳,🔳,🔳,🔳,🔳,🔳,🔳,🔳,🔳,🟥],
              [🔳,🔳,🔳,🔳,🔳,🔳,🔳,🔳,🔳,🟩],
              [🔳,🔳,🔳,🔳,🔳,🔳,🔳,🔳,🔳,🟩],
              [🔳,🔳,🔳,🟥,🔳,🔳,🔳,🔳,🔳,🟩],
              [🔳,🔳,🔳,🟦,🔳,🔳,🔳,🔳,🔳,🟥],
              [,🟩,🟩,🔳,🟩,🟥,🔳,🔳,🔳,🔳,🟥]]

//#-end-hidden-code
/*: some text
 ##  📖⑩条件で処理を変えよう！(1)

　top(1)〜top(10)を使うと、その「場所」の「一番上」にある宝石の「色」を調べることがでます。\
 🔳🔳🔳🔳🔳🔳🔳🔳🔳🔳\
 🔳🔳🔳🔳🔳🔳🔳🔳🔳🔳\
 🔳🔳🔳🔳🔳🔳🔳🔳🔳🔳\
 🔳🔳🔳🔳🔳🔳🔳🔳🔳🟦\
 🔳🔳🔳🔳🔳🔳🔳🔳🔳🟥\
 🔳🔳🔳🔳🔳🔳🔳🔳🔳🟩\
 🔳🔳🔳🔳🔳🔳🔳🔳🔳🟩\
 🔳🔳🔳🟥🔳🔳🔳🔳🔳🟩\
 🟩🔳🔳🟦🔳🔳🔳🔳🔳🟥\
 🟥🟩🔳🟩🟥🔳🔳🔳🔳🟥\
 　例えば、上の図のように宝石が落ちているとき、top(1)やtop(2)は「🟩」に、top(4)やtop(5)は「🟥」、
 top(10)は「🟦」になります。\
 　「top(1)」を使って、1番目の宝石と同じ「色」の宝石を3番目から9番目まで落とすプログラムを考えてみましょう。\
 　1番目には、どの「色」の宝石がおちてくるのかわからないので、top(1)で調べ、その「色」に応じて、次から落とす宝石の色を決めるために、\
 「if」を使います。\
　3から9番目の宝石の色が1番目の宝石と同じ「色」になっていることを、コードを何度か実行して確かめてみよう！
 
 * Important:
　「if」は、「もしも」という意味です。\
　「if(  )」の括弧の中に「条件」を指定します。例えば、括弧の中が「top(1) == 🟥」になっていると、「もしも、top(1)の値が🟥と等しければ、color(🟥)を実行」ということになります。
 ---
 */
//#-code-completion(everything, hide)
//#-code-completion(identifier, show, 🟥, 🟩, 🟦)
//#-hidden-code
clear()
randomColor()
drop(1)
color(🟥)
//#-end-hidden-code
//#-editable-code
//このプログラムでは、「色」が決まっていない宝石が最初に1番目に落ちます。
//ここからプログラムの始まり。
if(top(1) == 🟥) { //もし🟥のときは。
    color(🟥) //いろを🟥にします。
}
if(top(1) == 🟦) { //もし🟦のときは。
    color(🟦) //いろを🟦にします。
}
if(top(1) == 🟩) { //もし🟩のときは。
    color(🟩) //いろを🟩にします。
}
for i in 3...9 { //3番目から6番目に落とす。
    drop(i)
}

//#-end-editable-code
//#-hidden-code
if( PlaygroundPage.current.assessmentStatus == nil ){
    sendMessage("⑩-😊実行しました。")
    PlaygroundPage.current.assessmentStatus = .pass(message: "😄できました!")
}
//#-end-hidden-code
