//
//  See LICENSE folder for this template’s licensing information.
//
//  Abstract:
//   playground ライブビューとコード間のメッセージハンドリング
//   playground BluetoothによるconnectionViewの表示

import UIKit
import PlaygroundSupport

public class SetNameViewController: UIViewController,PlaygroundLiveViewSafeAreaContainer  {
    
    //各ビューを定義
    private var nameView = UIView()
    private var textField = UITextField()
    private var explaneLabel = UILabel()
    private var nameLabel = UILabel()
    private var settingButton = UIButton()

    //ユーザー名を保持
    private var userName: String? = nil
    

    public required init(coder aDecoder: NSCoder) {
        super.init(coder: aDecoder)!
    }
    
    public override init(nibName nibNameOrNil: String?, bundle nibBundleOrNil: Bundle?) {
        super.init(nibName: nibNameOrNil, bundle: nibBundleOrNil)
    }

    @objc func tapSettingButton(_ sender:UIButton) {
        //キーストアにデータを書き込む
        if((textField.text) != nil) {
            if (textField.text != "") {
                PlaygroundKeyValueStore.current["userName"] = .string(textField.text!)
                nameLabel.text = "現在のユーザー名 : " + (textField.text ?? "")
            }
        }
    }
    
    override public func viewDidLoad() {
        super.viewDidLoad()
        //キーストアからデータを読み込む（無ければデフォルト値を設定）
        if let keyValue = PlaygroundKeyValueStore.current["userName"],
            case .string(let storedUserName) = keyValue {
            userName = storedUserName
        } else {
            PlaygroundKeyValueStore.current["userName"] = .string("no Name")
            userName = "no Name"
        }
        
        // UIButtonを生成
        settingButton.frame = CGRect(x: 120, y: 100, width: 80, height: 30)
        settingButton.setTitle("セットする", for: UIControl.State.normal)
        settingButton.titleLabel!.font = UIFont(name: "HiraKakuProN-W6",size: 20)
        settingButton.setTitleColor(UIColor.black, for: UIControl.State.normal)
        settingButton.layer.cornerRadius = 5
        settingButton.backgroundColor = UIColor(red: 0.97, green: 0.97, blue: 0.97, alpha: 1.0)
        settingButton.layer.shadowColor = UIColor(red: 0, green: 0, blue: 0, alpha: 0.25).cgColor
        settingButton.layer.shadowOffset = CGSize(width: 0.0, height: 2.0)
        settingButton.layer.shadowOpacity = 1.0
        settingButton.layer.shadowRadius = 0.0
        settingButton.layer.masksToBounds = false
        settingButton.layer.cornerRadius = 4.0
        settingButton.addTarget(self, action: #selector(tapSettingButton(_:)), for: UIControl.Event.touchUpInside)

        view.addSubview(nameView)
        nameView.addSubview(nameLabel)
        nameView.addSubview(textField)
        nameView.addSubview(settingButton)
        nameView.addSubview(explaneLabel)
        
        explaneLabel.text = "現在設定されているユーザー名を表示しています。変更する時は、入力欄にユーザー名を入力して、［セットする］ボタンを押してください。"
        explaneLabel.textColor = UIColor.black
        explaneLabel.lineBreakMode = .byWordWrapping
        explaneLabel.numberOfLines = 0
        explaneLabel.font = UIFont.systemFont(ofSize: 20.0)
        
        nameLabel.frame = CGRect(x:0,y:0,width:200,height:50)
        nameLabel.textAlignment = .center
        nameLabel.text = "現在のユーザー名 : " + (userName ?? "")
        nameLabel.font = UIFont.systemFont(ofSize: 20.0)

        textField.frame = CGRect(x:0,y:0,width:200,height:50)
        textField.backgroundColor = UIColor(red: 1.0, green: 1.0, blue: 1.0, alpha: 0.5)
        //textField.borderStyle = .roundedRect
        textField.layer.cornerRadius = 10.0
        textField.layer.borderWidth = 1.0
        //textField.layer.borderColor = UIColor.gray.cgColor
        textField.clipsToBounds = true
        textField.setLeftPaddingPoints(10.0)
        textField.placeholder = "ここに入力してください"
        
        nameView.clipsToBounds = true //はみ出さない様にする。
        nameView.backgroundColor  = #colorLiteral(red: 0.2392156869, green: 0.6745098233, blue: 0.9686274529, alpha: 1)
        nameView.layer.cornerRadius = 0
        
        // Auto Layout設定
        nameView.translatesAutoresizingMaskIntoConstraints = false
        explaneLabel.translatesAutoresizingMaskIntoConstraints = false
        nameLabel.translatesAutoresizingMaskIntoConstraints = false
        textField.translatesAutoresizingMaskIntoConstraints = false
        settingButton.translatesAutoresizingMaskIntoConstraints = false

        NSLayoutConstraint.activate([
            // nameViewの制約
            nameView.topAnchor.constraint(equalTo: liveViewSafeAreaGuide.topAnchor, constant: 0),
            nameView.bottomAnchor.constraint(equalTo: liveViewSafeAreaGuide.bottomAnchor, constant: 0),
            nameView.leadingAnchor.constraint(equalTo: liveViewSafeAreaGuide.leadingAnchor, constant: 0),
            nameView.trailingAnchor.constraint(equalTo: liveViewSafeAreaGuide.trailingAnchor, constant: 0),

            // explaneLabelの制約
            explaneLabel.topAnchor.constraint(equalTo: nameView.topAnchor, constant: 10),
            explaneLabel.leadingAnchor.constraint(equalTo: nameView.leadingAnchor, constant: 20),
            explaneLabel.trailingAnchor.constraint(equalTo: nameView.trailingAnchor, constant: -20),
            explaneLabel.heightAnchor.constraint(greaterThanOrEqualToConstant: 80),
            // nameLabelの制約
            nameLabel.topAnchor.constraint(equalTo: explaneLabel.bottomAnchor, constant: 20),
            nameLabel.centerXAnchor.constraint(equalTo: nameView.centerXAnchor),
            nameLabel.leadingAnchor.constraint(equalTo: nameView.leadingAnchor, constant: 20),
            nameLabel.trailingAnchor.constraint(equalTo: nameView.trailingAnchor, constant: -20),
            // textViewの制約
            textField.topAnchor.constraint(equalTo: nameLabel.bottomAnchor, constant: 20),
            textField.centerXAnchor.constraint(equalTo: nameView.centerXAnchor),
            textField.widthAnchor.constraint(equalToConstant: 240),
            textField.heightAnchor.constraint(equalToConstant: 50),
            // settingButtonの制約
            settingButton.topAnchor.constraint(equalTo: textField.bottomAnchor, constant: 20),
            settingButton.centerXAnchor.constraint(equalTo: nameView.centerXAnchor),
            settingButton.widthAnchor.constraint(equalToConstant: 140),
            settingButton.heightAnchor.constraint(equalToConstant: 50)
        ])
    }
    
    override public func viewWillAppear(_ animated: Bool) {
    }
}

public extension UIButton {
    override func touchesBegan(_ touches: Set<UITouch>, with event: UIEvent?) {
       super.touchesBegan(touches, with: event)
        touchStartAnimation(p: self)
    }
    
    override func touchesCancelled(_ touches: Set<UITouch>, with event: UIEvent?) {
        super.touchesCancelled(touches, with: event)
        touchEndAnimation(p: self)
    }

    override func touchesEnded(_ touches: Set<UITouch>, with event: UIEvent?) {
        super.touchesEnded(touches, with: event)
        touchEndAnimation(p: self)
    }
}

public extension UITextField {
    func setLeftPaddingPoints(_ amount:CGFloat){
        let paddingView = UIView(frame: CGRect(x: 0, y: 0, width: amount, height: self.frame.size.height))
        self.leftView = paddingView
        self.leftViewMode = .always
    }
}

func touchStartAnimation(p: UIButton, duration: CGFloat = 0.1){
    UIView.animate(withDuration: duration,
        delay: 0.0,
        options: UIView.AnimationOptions.curveEaseIn,
        animations: {() -> Void in
            p.transform = CGAffineTransform(scaleX: 0.95, y: 0.95);
            p.alpha = 0.7
        },
        completion: nil
    )
}

func touchEndAnimation(p: UIButton, duration: CGFloat = 0.1){
    UIView.animate(withDuration: duration,
        delay: 0.0,
        options: UIView.AnimationOptions.curveEaseIn,
        animations: {() -> Void in
            p.transform = CGAffineTransform(scaleX: 1.0, y: 1.0);
            p.alpha = 1
        },
        completion: nil
    )
}

extension SetNameViewController: PlaygroundLiveViewMessageHandler {
    //Playgroundページからメッセージを受け取る際の処理。
    //public func receive(_ message: PlaygroundValue) {
    //}
    //Playgroundページにメッセージを送る際のサンプル。
    //public func tapped() {
    //    send(message)
    // }
    
}

