//
//  See LICENSE folder for this template’s licensing information.
//
//  Abstract:
//  Bonjourサービスへの通知クライアント

import Foundation
import Network
import UIKit
import PlaygroundSupport

class TCPClient: NSObject, NetServiceBrowserDelegate, NetServiceDelegate {
    var connection: NWConnection?
    var serviceBrowser: NetServiceBrowser?
    var service: NetService?
    //var status_message: String?
    
    func start() {
        //status_message = message
        serviceBrowser = NetServiceBrowser()
        serviceBrowser?.delegate = self
        serviceBrowser?.searchForServices(ofType: "_playgnd._tcp.", inDomain: "local.")
    }
    
    func send(message: String) {
        let data = message.data(using: .utf8) ?? Data()
        connection?.send(content: data, completion: .contentProcessed({ error in
            if let error = error {
                print("Failed to send message: \(error)")
            } else {
                print("Message sent")
            }
        }))
    }
    
    private func receiveMessages() {
        connection?.receive(minimumIncompleteLength: 1, maximumLength: 65536) { data, _, isComplete, error in
            if let data = data, !data.isEmpty {
                let message = String(data: data, encoding: .utf8) ?? ""
                print("Received: \(message)")
            }
            if isComplete || error != nil {
                self.connection?.cancel()
            } else {
                self.receiveMessages()
            }
        }
    }
    
    // NetServiceBrowserDelegate methods
    func netServiceBrowser(_ browser: NetServiceBrowser, didFind service: NetService, moreComing: Bool) {
        self.service = service
        service.delegate = self
        service.resolve(withTimeout: 10)
    }
    
    // NetServiceDelegate methods
    func netServiceDidResolveAddress(_ sender: NetService) {
        guard let addresses = sender.addresses, let _ = addresses.first else {
            print("No addresses found")
            return
        }
        
        // NWEndpoint.Hostのインスタンスを生成
        let host: NWEndpoint.Host
        if let hostname = sender.hostName {
            host = NWEndpoint.Host(hostname)
        } else {
            print("No host name found")
            return
        }
        
        let port = NWEndpoint.Port(integerLiteral: UInt16(sender.port))
        
        connection = NWConnection(to: .hostPort(host: host, port: port), using: .tcp)
        connection?.start(queue: .main)
        //receiveMessages()
    }
    
    func netService(_ sender: NetService, didNotResolve errorDict: [String : NSNumber]) {
        print("Failed to resolve service: \(errorDict)")
    }
}

