//#-hidden-code
//
//  See LICENSE folder for this template’s licensing information.
//
//  Abstract:
//  The Swift file containing the source code edited by the user of this playground book.
//
//#-end-hidden-code
/*: some text
# MESHのボタンブロックで画面の電球を灯そう！
  ![using MESH](100BU.png)
※このページでは、MESH ボタンブロックを使います。\
右上にある「MESH未接続」の表示をタップすると、近くにあるMESHブロックが表示されます。\
 このページでは、ボタンブロックを使うので、MESH-100BUで始まるMESHブロックを選んでください。\
  MESHブロックを初めて接続する時にはペアリングの確認がありますが、
 タイミングの都合でペアリングした直後は使用できません。ペアリングしたら、もう一度接続し直してください。\
 接続がうまくいったかどうか確認するためには、画面の下にある「コードを実行」ボタンを押して、
 プログラムとMESHブロックの接続を確認してみてください。\
 MESH ボタンブロックのプッシュで電球を点灯できたら、ボタンブロックの長押しで電球を消灯させてみましょう！\
 それがうまく出来たら、プッシュで電球を点灯、次のプッシュで電球を消灯するプログラムにも挑戦してみてください！
 
 * Note:
 MESHのボタンブロックからは、次の信号が送られてきます。\
 BU_PUSH（ボタンを押した）、BU_2PUSH（ボタンを連続２回押した）、BU_LPUSH（ボタンを長押しした）\
 light()は、右側にあるビュー（画面）の電球を操作する関数です。\
 "turn_on"を送ると点灯し、"turn_off"を送ると消灯します。\
 プログラム内にあるcounterは、ボタンが押された回数を数えています。
*/
/*: some text
 [ ]( )
 * Important:
 MESHと接続ができた状態でコードを実行しないと通信はできません。
*/
//#-hidden-code
let BU_PUSH: String = "01000102"
let BU_2PUSH:String = "01000304"
let BU_LPUSH:String = "01000203"

import PlaygroundSupport
let page = PlaygroundPage.current
var counter = 0
page.needsIndefiniteExecution = true
func light(_ str: String) {
   if let proxy1 = page.liveView as? PlaygroundRemoteLiveViewProxy {
       let message: PlaygroundValue = .string(str)
       proxy1.send(message)
   }
}
////////////////////////////////////////////////////////////
let proxy2 = page.liveView as? PlaygroundRemoteLiveViewProxy
class MyClassThatListens: PlaygroundRemoteLiveViewProxyDelegate {
    func remoteLiveViewProxy(_ remoteLiveViewProxy: PlaygroundRemoteLiveViewProxy,received message: PlaygroundValue) {

if case let .string(text) = message {
//#-end-hidden-code
//#-code-completion(everything, hide)
//MESHから信号を受け取った時の処理
//#-editable-code
if(text == BU_PUSH) {//ボタンが押された
    light("turn_on")
    counter += 1
}
if(text == BU_LPUSH) {

}
//#-end-editable-code
//#-hidden-code
}

}
    func remoteLiveViewProxyConnectionClosed(_ remoteLiveViewProxy: PlaygroundRemoteLiveViewProxy) {
        //コネクション切断時の処理
    }
}
let listenter = MyClassThatListens()
proxy2?.delegate = listenter
//#-end-hidden-code
