//#-hidden-code
//
//  See LICENSE folder for this template’s licensing information.
//
//  Abstract:
//  The Swift file containing the source code edited by the user of this playground book.
//
//#-end-hidden-code
/*: some text
# MESHのボタンブロックが画像変化のきっかけに！
![using MESH](100BU.png)
※このページでは、MESH ボタンブロックを使います。\
ボタンを押したことをきっかけにして、画像が変化していく様子を確認してみてください！
* Note:
MESHのボタンブロックからは、次の信号が送られてきます。\
BU_PUSH（ボタンを押した）、BU_2PUSH（ボタンを連続２回押した）、BU_LPUSH（ボタンを長押しした）\
light()は、右側にあるビュー（画面）の画像を操作する関数です。\
"turn_on"を送ると回転し、"turn_off"を送ると最初に戻ります。\
ボタンを長押しをすると、回転の方向が切り替わります。
*/
/*: some text
 [ ]( )
 * Important:
 MESHと接続ができた状態でコードを実行しないと通信はできません。
 */
//#-hidden-code
let BU_PUSH: String = "01000102"
let BU_2PUSH:String = "01000304"
let BU_LPUSH:String = "01000203"

import PlaygroundSupport
let page = PlaygroundPage.current
page.needsIndefiniteExecution = true

func light(_ str: String) {
   if let proxy1 = page.liveView as? PlaygroundRemoteLiveViewProxy {
       let message: PlaygroundValue = .string(str)
       proxy1.send(message)
   }
}
////////////////////////////////////////////////////////////
let proxy2 = page.liveView as? PlaygroundRemoteLiveViewProxy
class MyClassThatListens: PlaygroundRemoteLiveViewProxyDelegate {
    func remoteLiveViewProxy(_ remoteLiveViewProxy: PlaygroundRemoteLiveViewProxy,received message: PlaygroundValue) {

if case let .string(text) = message {
//#-end-hidden-code
//#-code-completion(everything, hide)
 //MESHから信号を受け取った時の処理
 //#-editable-code
  if(text == BU_PUSH) {
    light("turn_on")
    }
    if(text == BU_2PUSH){
        light("double_Press")
    }
  if(text == BU_LPUSH) {
    light("turn_off")
    }
//#-end-editable-code
    //#-hidden-code
}
}
    func remoteLiveViewProxyConnectionClosed(_ remoteLiveViewProxy: PlaygroundRemoteLiveViewProxy) {
        //コネクション切断時の処理
    }
}
let listenter = MyClassThatListens()
proxy2?.delegate = listenter
//#-end-hidden-code
