//#-hidden-code
//
//  See LICENSE folder for this template’s licensing information.
//
//  Abstract:
//  The Swift file containing the source code edited by the user of this playground book.
//
//#-end-hidden-code
/*: some text
 # MESHのLEDブロックを好きな色で灯そう！
 ![using MESH](100LE.png)
 ※このページでは、MESH LEDブロックを使います。\
 右上にある「MESH未接続」の表示をタップすると、近くにあるMESHブロックが表示されます。\
 このページでは、LEDブロックを使うので、MESH-100LEで始まるMESHブロックを選んでください。\
 画面のスライダを使うと、「赤」「緑」「青」の光の強さで色が作れます。
 
 * Note:
 MESHのLEDブロックには、sendLED()を使って次の指示を送ることができます。\
 "turn_on"（画面で指定した色でLEDを点灯）、"turn_off"（LEDを消灯）、"00000000"(２桁の16進数）RGBと点灯時間を合計計8桁で指定でして点灯する。
 */
/*: some text
 [ ]( )
 * Important:
 MESHと接続ができた状態でコードを実行しないと通信はできません。
 */
//#-hidden-code
import PlaygroundSupport
import AudioToolbox
let page = PlaygroundPage.current
page.needsIndefiniteExecution = true

func sendLED(_ str: String) {
   if let proxy1 = page.liveView as? PlaygroundRemoteLiveViewProxy {
       let message: PlaygroundValue = .string(str)
       proxy1.send(message)
   }
}
//#-end-hidden-code
//#-code-completion(everything, hide)
//#-editable-code
//sendLED("0a000a10") //R=0a,G=00,B=0a,時間160msで点灯
sendLED("turn_on")
//#-end-editable-code
//#-hidden-code
////////////////////////////////////////////////////////////
let proxy2 = page.liveView as? PlaygroundRemoteLiveViewProxy
class MyClassThatListens: PlaygroundRemoteLiveViewProxyDelegate {
    func remoteLiveViewProxy(_ remoteLiveViewProxy: PlaygroundRemoteLiveViewProxy,received message: PlaygroundValue) {
       //MESHから信号を受け取った時の処理
}
func remoteLiveViewProxyConnectionClosed(_ remoteLiveViewProxy: PlaygroundRemoteLiveViewProxy) {
        //コネクション切断時の処理
    }
}
let listenter = MyClassThatListens()
proxy2?.delegate = listenter
//#-end-hidden-code
