//#-hidden-code
//
//  See LICENSE folder for this template’s licensing information.
//
//  Abstract:
//  The Swift file containing the source code edited by the user of this playground book.
//
//#-end-hidden-code
/*: some text
 # 画面タップでLEDブロックを光らせよう！
 ![using MESH](100LE.png)
 ※このページでは、MESH LEDブロックを使います。\
 * Note:
 MESHのLEDブロックには、sendLED()を使って次の指示を送ることができます。\
 Migi_Botan(画面の右側のボタン)\
 Hidari_Botan(画面の左側のボタン)\
 "atari"（画面で指定したLEDが青く点灯）、"hazure"（画面で指定したLEDが赤く点灯）します。\
 */
/*: some text
 [ ]( )
 * Important:
 MESHと接続ができた状態でコードを実行しないと通信はできません。
 */
//#-hidden-code
let BU_PUSH: String = "01000102"
let BU_2PUSH:String = "01000304"
let BU_LPUSH:String = "01000203"
let Migi_Botan:String = "right"
let Hidari_Botan:String = "left"

import PlaygroundSupport
let page = PlaygroundPage.current
page.needsIndefiniteExecution = true

func light(_ str: String) {
   if let proxy1 = page.liveView as? PlaygroundRemoteLiveViewProxy {
       let message: PlaygroundValue = .string(str)
       proxy1.send(message)
   }
}
////////////////////////////////////////////////////////////
let proxy2 = page.liveView as? PlaygroundRemoteLiveViewProxy
class MyClassThatListens: PlaygroundRemoteLiveViewProxyDelegate {
    func remoteLiveViewProxy(_ remoteLiveViewProxy: PlaygroundRemoteLiveViewProxy,received message: PlaygroundValue) {
if case let .string(text) = message {
//#-end-hidden-code
//#-code-completion(everything, hide)
 //MESHから信号を受け取った時の処理
 //#-editable-code
  if(text == Migi_Botan) {
      light("atari")
      }
  if(text == Hidari_Botan) {
      light("hazure")
      }
//#-end-editable-code
//#-hidden-code
}
}
    func remoteLiveViewProxyConnectionClosed(_ remoteLiveViewProxy: PlaygroundRemoteLiveViewProxy) {
        //コネクション切断時の処理
    }
}
let listenter = MyClassThatListens()
proxy2?.delegate = listenter
//#-end-hidden-code
