//#-hidden-code
//
//  See LICENSE folder for this template’s licensing information.
//
//  Abstract:
//  The Swift file containing the source code edited by the user of this playground book.
//
//#-end-hidden-code
/*: some text
 # MESHの動きブロックで物体を回転させよう！
 ![using MESH](100AC.png)
 ※このページでは、MESH 動きブロックを使います。\
 MESH-100ACから始まるブロックと接続してください。\
 動きをコントロールするプログラムにも挑戦してみてください！
 
 * Note:
 MESHの動きブロックからは、次の信号が送られてきます。\
 DIR_OMOTE（表側が上になった）、\
 DIR_URA（裏側が上になった）、\
 DIR_MIGI（右側が上になった）、\
 DIR_HIDARI（左側が上になった）、\
 DIR_UE（上側が上になった）、\
 DIR_SITA（下側が上になった）\
 rotate()は、右側ビューの物体を回転させる関数です。\
 "turn_left"でz軸周りに-45度、\
 "turn_right"でz軸周りに45度、\
 "turn_up"でx軸周りに45度、\
 "turn_down"でx軸周りに-45度回転します。\
物体の位置をMESH 動きブロックで自由に動かせるようにプログラミングしてみましょう！
 */
/*: some text
 [ ]( )
 * Important:
 MESHと接続ができた状態でコードを実行しないと通信はできません。
 */
//#-hidden-code
let DIR_OMOTE: String = "010303"
let DIR_URA:String = "010304"
let DIR_MIGI:String = "010306"
let DIR_HIDARI:String = "010301"
let DIR_UE:String = "010305"
let DIR_SITA:String = "010302"

import PlaygroundSupport
let page = PlaygroundPage.current
var counter = 0
page.needsIndefiniteExecution = true
func rotate(_ str: String) {
    if let proxy1 = page.liveView as? PlaygroundRemoteLiveViewProxy {
        let message: PlaygroundValue = .string(str)
        proxy1.send(message)
    }
}
////////////////////////////////////////////////////////////
let proxy2 = page.liveView as? PlaygroundRemoteLiveViewProxy
class MyClassThatListens: PlaygroundRemoteLiveViewProxyDelegate {
    func remoteLiveViewProxy(_ remoteLiveViewProxy: PlaygroundRemoteLiveViewProxy,received message: PlaygroundValue) {
        
        if case let .string(text) = message {
            //#-end-hidden-code
            //#-code-completion(everything, hide)
//MESHから信号を受け取った時の処理
//#-editable-code
if(text == DIR_HIDARI) {
  rotate("turn_left")
} else if( text == DIR_MIGI) {
  rotate("turn_right")
}
//#-end-editable-code
//#-hidden-code
        }
        
    }
    func remoteLiveViewProxyConnectionClosed(_ remoteLiveViewProxy: PlaygroundRemoteLiveViewProxy) {
        //コネクション切断時の処理
    }
}
let listenter = MyClassThatListens()
proxy2?.delegate = listenter
//#-end-hidden-code

