//#-hidden-code
//
//  See LICENSE folder for this template’s licensing information.
//
//  Abstract:
//  The Swift file containing the source code edited by the user of this playground book.
//
//#-end-hidden-code
/*: some text
 # 動きブロックでサイコロを回そう！
 ![using MESH](100AC.png)
 ※このページでは、MESH 動きブロックを使います。\
 MESH-100ACから始まるブロックと接続してください。\
 * Note:
 MESHの動きブロックからは、次の信号が送られてきます。\
 Front（表側が上になった）、\
 Back（裏側が上になった）、\
 Top（右側が上になった）、\
 Under（左側が上になった）、\
 Right（上側が上になった）、\
 Left（下側が上になった）\
 dice()は、右側ビューのサイコロの数字を変化させる関数です。\
 物体の位置をMESH 動きブロックで自由に動かせるようにプログラミングしてみましょう！
 */
/*: some text
 [ ]( )
 * Important:
 MESHと接続ができた状態でコードを実行しないと通信はできません。
 */
//#-hidden-code
let BU_PUSH: String = "01000102"
let BU_2PUSH:String = "01000304"
let BU_LPUSH:String = "01000203"
let Front:String = "010303"
let Back:String = "010304"
let Top:String = "010305"
let Under:String = "010302"
let Right:String = "010301"
let Left:String = "010306"

import PlaygroundSupport
let page = PlaygroundPage.current
page.needsIndefiniteExecution = true

func dice(_ str: String) {
   if let proxy1 = page.liveView as? PlaygroundRemoteLiveViewProxy {
       let message: PlaygroundValue = .string(str)
       proxy1.send(message)
   }
}
////////////////////////////////////////////////////////////
let proxy2 = page.liveView as? PlaygroundRemoteLiveViewProxy
class MyClassThatListens: PlaygroundRemoteLiveViewProxyDelegate {
    func remoteLiveViewProxy(_ remoteLiveViewProxy: PlaygroundRemoteLiveViewProxy,received message: PlaygroundValue) {
if case let .string(text) = message {
//#-end-hidden-code
//#-code-completion(everything, hide)
 //MESHから信号を受け取った時の処理
 //#-editable-code
  if(text == Front){
      dice("dice3")
      }
  if(text == Back){
      dice("dice4")
      }
  if(text == Top){
      dice("dice5")
      }
  if(text == Under){
      dice("dice2")
      }
  if(text == Right){
      dice("dice1")
      }
  if(text == Left){
      dice("dice6")
      }
//#-end-editable-code
//#-hidden-code
}
}
    func remoteLiveViewProxyConnectionClosed(_ remoteLiveViewProxy: PlaygroundRemoteLiveViewProxy) {
        //コネクション切断時の処理
    }
}
let listenter = MyClassThatListens()
proxy2?.delegate = listenter
//#-end-hidden-code
