//#-hidden-code
//
//  See LICENSE folder for this template’s licensing information.
//
//  Abstract:
//  The Swift file containing the source code edited by the user of this playground book.
//
//#-end-hidden-code
/*: some text
 # MESHのボタンと動きブロックで画面の電球を灯そう！
 ![using MESH](BUandAC.png)
 ※このページでは、ボタンブロックと動きブロックを使います。

 * Note:
 MESHのボタンブロックからは、次の信号が送られてきます。\
 BU_PUSH（ボタンを押した）、BU_2PUSH（ボタンを連続２回押した）、BU_LPUSH（ボタンを長押しした）\
 MESHの動きブロックからは、次の信号が送られてきます。\
 DIR_OMOTE（表側が上になった）、\
 DIR_URA（裏側が上になった）、\
 DIR_MIGI（右側が上になった）、\
 DIR_HIDARI（左側が上になった）、\
 DIR_UE（上側が上になった）、\
 DIR_SITA（下側が上になった）\
 light()は、右側にあるビュー（画面）の電球を操作する関数です。\
 "turn_on"を送ると点灯し、"turn_off"を送ると消灯します。\
 どちらのブロックを使っても電球の点灯・消灯ができるようにプログラミングしてみましょう！
それが出来たら、動きブロックが表が上の時だけ電球が点灯できるようにしてみよう！
 そのためには状態を保持するための変数 state を使ってみてください。\
 stateがtrue（真）の時には操作が出来て、false（偽）の時には操作を出来なくすれば良く、
 このstateの値は動きタグの指示で変えるようにすればできます。最初にstateにはfalseが入っています。\
 また、プログラム内にあるcounterは、ボタンが押された回数を数えています。
 */
/*: some text
 [ ]( )
 * Important:
 MESHと接続ができた状態でコードを実行しないと通信はできません。
 */
//#-hidden-code
let BU_PUSH: String = "01000102"
let BU_2PUSH:String = "01000304"
let BU_LPUSH:String = "01000203"
let DIR_OMOTE: String = "010303"
let DIR_URA:String = "010304"
let DIR_MIGI:String = "010306"
let DIR_HIDARI:String = "010301"
let DIR_UE:String = "010305"
let DIR_SITA:String = "010302"

import PlaygroundSupport
let page = PlaygroundPage.current
var counter = 0
var state = false
page.needsIndefiniteExecution = true
func light(_ str: String) {
    if let proxy1 = page.liveView as? PlaygroundRemoteLiveViewProxy {
        let message: PlaygroundValue = .string(str)
        proxy1.send(message)
    }
}
////////////////////////////////////////////////////////////
let proxy2 = page.liveView as? PlaygroundRemoteLiveViewProxy
class MyClassThatListens: PlaygroundRemoteLiveViewProxyDelegate {
    func remoteLiveViewProxy(_ remoteLiveViewProxy: PlaygroundRemoteLiveViewProxy,received message: PlaygroundValue) {
        
if case let .string(text) = message {
//#-end-hidden-code
//#-code-completion(everything, hide)
//MESHから信号を受け取った時の処理
//#-editable-code
if(text == BU_PUSH) {//ボタン１回押し
    light("turn_on")
    counter += 1
}
if(text == BU_2PUSH) {//ボタン２回押し
    light("turn_off")
}
if(text ==  DIR_OMOTE) {//表面が上
    light("turn_on")
}
if(text == DIR_URA) { //裏面が上
    light("turn_off")
}
//#-end-editable-code
//#-hidden-code
        }
        
    }
    func remoteLiveViewProxyConnectionClosed(_ remoteLiveViewProxy: PlaygroundRemoteLiveViewProxy) {
        //コネクション切断時の処理
    }
}
let listenter = MyClassThatListens()
proxy2?.delegate = listenter
//#-end-hidden-code

