//
//  See LICENSE folder for this template’s licensing information.
//
//  Abstract:
//   playground ライブビューとコード間のメッセージハンドリング
//   playground BluetoothによるconnectionViewの表示

import UIKit
import PlaygroundSupport
import CoreBluetooth
import SceneKit
import PlaygroundBluetooth


//let BATTERY_MODE = true
//var connectionView:PlaygroundBluetoothConnectionView?

public class DiceViewController: UIViewController,PlaygroundLiveViewSafeAreaContainer  {
    
    private var myTextView  = UITextView()
    private var myScene = SCNScene()
    private var sceneView = SCNView()
    private var myImageView = UIImageView()
    private var myInputText = UITextView()
    private var myUIButton  = UIButton()
    private var vstring = String()
    private var myNode = SCNNode()
    
    
    //接続したmesh用のname保持用
    private var meshname = String()
    
    //タイマー関係
    private var timer: Timer!
    private var startTime = Date()
    private var timerMinute = UITextView()
    private var timerSecond = UITextView()
    private var timerMSec = UITextView()
    private var timer_bool = false
    private var timer_reset = false
    private var timer_rate_1 = Double()
    private var timer_rate_2 = Double()
    
    
    //動きメッシュ関係とか
    private var meshdice = Int()
    private let dice1:UIImage = UIImage(named: "dice1.png")!
    private let dice2:UIImage = UIImage(named: "dice2.png")!
    private let dice3:UIImage = UIImage(named: "dice3.png")!
    private let dice4:UIImage = UIImage(named: "dice4.png")!
    private let dice5:UIImage = UIImage(named: "dice5.png")!
    private let dice6:UIImage = UIImage(named: "dice6.png")!
    //LEDmesh関係
    
//
    private var centralManager = PlaygroundBluetoothCentralManager(services:[serviceUuid])
    private var connectionView: PlaygroundBluetoothConnectionView!
    private var myCharacteristic: CBCharacteristic!
    private var myCharacteristicI: CBCharacteristic!
    private var myCharacteristicW: CBCharacteristic!
    private var myCharacteristicN: CBCharacteristic!
    private var myPeripheral: CBPeripheral!
    private var myConnect = false
    
    public required init(coder aDecoder: NSCoder) {
        super.init(coder: aDecoder)!
    }
    
    public override init(nibName nibNameOrNil: String?, bundle nibBundleOrNil: Bundle?) {
        super.init(nibName: nibNameOrNil, bundle: nibBundleOrNil)
    }
    
    override public func viewDidLoad() {
        super.viewDidLoad()
        view.backgroundColor = #colorLiteral(red: 0.4745098054, green: 0.8392156959, blue: 0.9764705896, alpha: 1)
        // disable auto layout
        view.translatesAutoresizingMaskIntoConstraints = false

        //セントラルマネージャ
        centralManager.delegate = self
        // コネクションビューの設定connectionView settings
        connectionView = PlaygroundBluetoothConnectionView(centralManager: centralManager)
        connectionView.delegate = self
        connectionView.dataSource = self
        
        // ビューパーツをコンテナ基準で配置
        
       //テキストビューを配置
        myTextView.font = UIFont.systemFont(ofSize: 20)
        myTextView.isEditable = false
        view.addSubview(myTextView)
        myTextView.backgroundColor  = #colorLiteral(red: 1, green: 1, blue: 1, alpha: 0.5)
        myTextView.layer.cornerRadius = 10
        myTextView.translatesAutoresizingMaskIntoConstraints  = false
        myTextView.topAnchor.constraint(equalTo: liveViewSafeAreaGuide.topAnchor, constant: 90).isActive = true
         myTextView.bottomAnchor.constraint(equalTo: liveViewSafeAreaGuide.bottomAnchor, constant: -40).isActive = true
        myTextView.leadingAnchor.constraint(equalTo: liveViewSafeAreaGuide.leadingAnchor, constant: 20).isActive = true
        myTextView.trailingAnchor.constraint(equalTo: liveViewSafeAreaGuide.trailingAnchor, constant: -20).isActive = true
        
        
        //シーンビューを配置
        pb()
        sceneView.allowsCameraControl = false
        sceneView.autoenablesDefaultLighting = true
        sceneView.showsStatistics = false
        sceneView.scene = myScene
        
        view.addSubview(sceneView)
        sceneView.backgroundColor = #colorLiteral(red: 1, green: 1, blue: 1, alpha: 0.5)
        sceneView.translatesAutoresizingMaskIntoConstraints  = false
        sceneView.topAnchor.constraint(equalTo: liveViewSafeAreaGuide.topAnchor, constant: 100).isActive = true
        sceneView.bottomAnchor.constraint(equalTo: liveViewSafeAreaGuide.bottomAnchor, constant: -50).isActive = true
        sceneView.leadingAnchor.constraint(equalTo: liveViewSafeAreaGuide.leadingAnchor, constant: 30).isActive = true
        sceneView.trailingAnchor.constraint(equalTo: liveViewSafeAreaGuide.trailingAnchor, constant: -30).isActive = true
        
//        //ボタンを配置
//        myUIButton.isEnabled = true
//        myUIButton.backgroundColor  = #colorLiteral(red: 0.2549019754, green: 0.2745098174, blue: 0.3019607961, alpha: 1)
//        myUIButton.layer.cornerRadius = 10
//        myUIButton.addTarget(self, action: #selector(self.pb), for: .touchUpInside)
//        //myUIButton.addTarget(self, action: #selector(self.db), for: .touchDown)
//        myUIButton.isEnabled = true
//        myUIButton.setTitle("シーンをリセット", for: UIControl.State.normal)
//        view.addSubview(myUIButton)
//        myUIButton.translatesAutoresizingMaskIntoConstraints  = false
//        myUIButton.topAnchor.constraint(equalTo: myTextView.bottomAnchor, constant: -60).isActive = true
//
//        myUIButton.heightAnchor.constraint(equalToConstant: 40.0).isActive = true
//        myUIButton.widthAnchor.constraint(equalToConstant: 150.0).isActive = true
//        myUIButton.centerXAnchor.constraint(equalTo: myTextView.centerXAnchor).isActive = true
        
        
        //BluetoothのconnectionViewを配置
        view.addSubview(connectionView)
        // Position the connection view in the top right corner.
       connectionView.topAnchor.constraint(equalTo: liveViewSafeAreaGuide.topAnchor, constant: 20).isActive = true
       connectionView.trailingAnchor.constraint(equalTo: liveViewSafeAreaGuide.trailingAnchor, constant: -20).isActive = true
        
        

    }
    
    override public func viewWillAppear(_ animated: Bool) {
    }
    
    @objc func db(){
        myUIButton.layer.shadowOpacity = 0.0
    }
    
    @objc func pb(){
        myScene.rootNode.enumerateChildNodes { (node, stop) in
            node.removeFromParentNode()
        }
        let box = SCNBox(width: 0.8, height: 0.8, length: 0.8, chamferRadius: 0.1)
        // 6面、別々のテクスチャを貼る
        let m1 = SCNMaterial()
        let m2 = SCNMaterial()
        let m3 = SCNMaterial()
        let m4 = SCNMaterial()
        let m5 = SCNMaterial()
        let m6 = SCNMaterial()
        m1.diffuse.contents = UIImage(named: "dice1.png")
        m2.diffuse.contents = UIImage(named: "dice2.png")
        m3.diffuse.contents = UIImage(named: "dice6.png")
        m4.diffuse.contents = UIImage(named: "dice5.png")
        m5.diffuse.contents = UIImage(named: "dice4.png")
        m6.diffuse.contents = UIImage(named: "dice3.png")
        box.materials = [m1, m2, m3, m4, m5, m6]
        myNode = SCNNode(geometry: box)
        // カメラ
        let cameraNode = SCNNode()
        cameraNode.camera = SCNCamera()
        cameraNode.position = SCNVector3(x: 0, y: 0, z: 2)
        myScene.rootNode.addChildNode(myNode)
        myScene.rootNode.addChildNode(cameraNode)
    }
}

extension DiceViewController: PlaygroundLiveViewMessageHandler {
    //Playgroundページからメッセージを受け取る際の処理。
    public func receive(_ message: PlaygroundValue) {
        if case let .string(text) = message {
            //CGFloat(-45 * (Float.pi / 180))
            if(text == "dice1"){
                myNode.runAction(
                    SCNAction.rotateTo(x: 0, y: 0, z: 0, duration: 0.2)
                )
            }
            if(text == "dice2"){
                myNode.runAction(
                    SCNAction.rotateTo(x: 0, y: CGFloat(-90 * (Float.pi / 180)), z: 0, duration: 0.2)
                )
            }
            if(text == "dice3"){
                myNode.runAction(
                    SCNAction.rotateTo(x: CGFloat(-90 * (Float.pi / 180)), y: 0, z: 0, duration: 0.2)
                )
            }
            if(text == "dice4"){
                myNode.runAction(
                    SCNAction.rotateTo(x: CGFloat(90 * (Float.pi / 180)), y: 0, z: 0, duration: 0.2)
                )
            }
            if(text == "dice5"){
                myNode.runAction(
                    SCNAction.rotateTo(x: 0, y: CGFloat(90 * (Float.pi / 180)), z: 0, duration: 0.2)
                )
            }
            if(text == "dice6"){
                myNode.runAction(
                    SCNAction.rotateTo(x: 0, y: CGFloat(180 * (Float.pi / 180)), z: 0, duration: 0.2)
                )
            }
        }
    }
    //Playgroundページにメッセージを送る際のサンプル。
    public func tapped() {
        let message: PlaygroundValue = .string("Hello!")
        //myTextView.insertText("[send to your code]Hello!\n")
        send(message)
    }
    
    override public func viewWillDisappear(_ animated: Bool) {
        super.viewWillDisappear(true)
        timer.invalidate()
    }
    
    
}

extension DiceViewController: PlaygroundBluetoothConnectionViewDelegate {
    
    public func connectionView(_ connectionView: PlaygroundBluetoothConnectionView, shouldDisplayDiscovered peripheral: CBPeripheral, withAdvertisementData advertisementData: [String : Any]?, rssi: Double) -> Bool {
        return true
    }
    
    public func connectionView(_ connectionView: PlaygroundBluetoothConnectionView, shouldConnectTo peripheral: CBPeripheral, withAdvertisementData advertisementData: [String : Any]?, rssi: Double) -> Bool {
        return true
    }
    
    public func connectionView(_ connectionView: PlaygroundBluetoothConnectionView, willDisconnectFrom peripheral: CBPeripheral) {
    }
    
    public func connectionView(_ connectionView: PlaygroundBluetoothConnectionView, titleFor state: PlaygroundBluetoothConnectionView.State) -> String {
        //Viewのタイトル文字列を返す
        //return "状態"
        let str = "\(state)"
        if(str == "noConnection") {
            return "MESH未接続"
        } else if (str == "selectingPeripherals") {
            return "MESHブロックの選択"
        } else {
            return "\(state)"
        }
    }
    
    public func connectionView(_ connectionView: PlaygroundBluetoothConnectionView, firmwareUpdateInstructionsFor peripheral: CBPeripheral) -> String {
        return #function
    }
}

extension DiceViewController: PlaygroundBluetoothConnectionViewDataSource {
    public func connectionView(_ connectionView: PlaygroundBluetoothConnectionView, itemForPeripheral peripheral: CBPeripheral, withAdvertisementData advertisementData: [String : Any]?) ->  PlaygroundBluetoothConnectionView.Item {
        //myTextView.insertText("[connectionView:advertisementData1]\(String(describing: advertisementData))\n")
        //myTextView.insertText("[connectionView:advertisementData2]\(peripheral)\n")

        let name = peripheral.name ?? "Unknown" //peripheral.nameがnilのときはnameをUnknownとする。
        var icon = UIImage()
        if name.contains("MESH-100AC") {
            icon = UIImage(named:"MESH-icon/MESH-100AC@2x.png")!
        } else if name.contains("MESH-100LE") {
            icon = UIImage(named:"MESH-icon/MESH-100LE@2x.png")!
        } else if name.contains("MESH-100BU") {
            icon = UIImage(named:"MESH-icon/MESH-100BU@2x.png")!
        } else if name.contains("MESH-100GP") {
            icon = UIImage(named:"MESH-icon/MESH-100GP@2x.png")!
        } else if name.contains("MESH-100PA") {
            icon = UIImage(named:"MESH-icon/MESH-100PA@2x.png")!
        } else if name.contains("MESH-100TH") {
            icon = UIImage(named:"MESH-icon/MESH-100TH@2x.png")!
        }else if name.contains("MESH-100MD") {
            icon = UIImage(named:"MESH-icon/MESH-100MD@2x.png")!
        }else if name.contains("iPhone") {
            icon = UIImage(named:"icon_iphone@2x.png")!
        }else if name.contains("micro:bit") {
                    icon = UIImage(named:"icon_microbit@2x.png")!
        }else {
                    icon = UIImage(named:"icon_Unknown@2x.png")!
        }
        let item = PlaygroundBluetoothConnectionView.Item(name: name, icon: icon, issueIcon: icon)
        return item
    }
}

extension DiceViewController: PlaygroundBluetoothCentralManagerDelegate {
    
    public func centralManagerStateDidChange(_ centralManager: PlaygroundBluetoothCentralManager) {
        if centralManager.state == CBManagerState.poweredOff {
           // print("turn on iPad's Bluetooth.")
           // myTextView.insertText("[centralManager]turn on iPad's Bluetooth.\n")
        }
    }
    
    public func centralManager(_ centralManager: PlaygroundBluetoothCentralManager, didDiscover peripheral: CBPeripheral, withAdvertisementData advertisementData: [String : Any]?, rssi: Double) {
      //  myTextView.insertText("[centralManager1]check\n")
        
    }
    
    public func centralManager(_ centralManager: PlaygroundBluetoothCentralManager, willConnectTo peripheral: CBPeripheral) {
        //print("Connect Start:" + peripheral.name! + "\n")
       // myTextView.insertText("[centralManager]Connect start:" + peripheral.name! + "\n")
        myPeripheral = peripheral
    }
    
    public func centralManager(_ centralManager: PlaygroundBluetoothCentralManager, didConnectTo peripheral: CBPeripheral) {
        //myTextView.insertText("[centralManager]set peripheral delegate\n")
        peripheral.delegate = self
        peripheral.discoverServices([serviceUuid])
        
        myImageView.image = nil
        let name = peripheral.name ?? "Unknown" //peripheral.nameがnilのときはnameをUnknownとする。
        if name.contains("MESH-100AC") {
            //動きタグ
            meshname = "MESH-100AC"

        } else if name.contains("MESH-100LE") {
            //LEDタグ
            meshname = "MESH-100LE"
//            let myImage: UIImage = UIImage(named: "lightImageOn.png")!
//            myImageView.image = myImage
        } else if name.contains("MESH-100BU") {
            //ボタンタグ
            meshname = "MESH-100BU"
        } else if name.contains("MESH-100GP") {
            
        } else if name.contains("MESH-100PA") {
            
        } else if name.contains("MESH-100TH") {
            
        }else if name.contains("MESH-100MD") {
            
        }else if name.contains("iPhone") {
            
        }else if name.contains("micro:bit") {
            
        }else {
            
        }
    }
    
    public func centralManager(_ centralManager: PlaygroundBluetoothCentralManager, didFailToConnectTo peripheral: CBPeripheral, error: Error?) {
        //myTextView.insertText("[centralManager]fail to connect\n")
    }
    
    public func centralManager(_ centralManager: PlaygroundBluetoothCentralManager, didDisconnectFrom peripheral: CBPeripheral, error: Error?) {
       // myTextView.insertText("[centralManager]disconnected.\n")
        myPeripheral = nil
        myCharacteristic = nil
    }
}

extension DiceViewController: CBPeripheralDelegate {
    public func peripheral(_ peripheral: CBPeripheral, didDiscoverServices error: Error?) {
        //サービスが検出された。
        //myTextView.insertText("[CBPeripheralDelegate]\(String(describing: peripheral.services))\n")
        if let service = peripheral.services?.first(where: { $0.uuid == serviceUuid }) {
        //myTextView.insertText("[CBPeripheral1]check2\n")
           // peripheral.discoverCharacteristics([characteristicUuid], for: service)
            peripheral.discoverCharacteristics([characteristicUuidI, characteristicUuidW, characteristicUuidN, characteristicUuidWwo], for: service)
        }
    }
    
    public func peripheral(_ peripheral: CBPeripheral, didDiscoverCharacteristicsFor service: CBService, error: Error?) {
        if error != nil {
            //myTextView.insertText("[DEBUG] error discovering characteristics: \(error)")
            return
        }
        //ペアリング済みでないデバイスの場合にはペアリングアラートを表示
        //
        //myTextView.insertText("[CBPeripheral2]check1\n")
            myPeripheral = peripheral
        if let characteristic = service.characteristics?.first(where: { $0.uuid == characteristicUuidI}) {
           //myTextView.insertText("Indicate activation\n")
            myCharacteristicI = characteristic
            if myCharacteristicI.properties.contains(.indicate) {
               // myTextView.insertText("Indicate contained\n")
                peripheral.setNotifyValue(true, for: myCharacteristicI)
            }
           // myTextView.insertText("Indicate activated\n")
            //write activation code
            if let characteristic = service.characteristics?.first(where: { $0.uuid == characteristicUuidW }) {
                myCharacteristicW = characteristic
                if myCharacteristicW.properties.contains(.write) {
                //myTextView.insertText("Write contained\n")
                    let data = Data(bytes: [0x00, 0x02, 0x01, 0x03])
                    myPeripheral.writeValue(data, for: myCharacteristicW, type: CBCharacteristicWriteType.withResponse)
                    //0x00020103を送ると、MESHからペアリング要求がくる。
                    
                }
                //myTextView.insertText("Write activated\n")
                //Notify activation
                if let characteristic = service.characteristics?.first(where: { $0.uuid == characteristicUuidN }) {
                    myCharacteristicN = characteristic
                    if myCharacteristicN.properties.contains(.notify) {
                      //myTextView.insertText("Notify contained\n")
                        peripheral.setNotifyValue(true, for: myCharacteristicN)
                    }
                   // let state = peripheral.state
                    //let num = state.rawValue
                      //myTextView.insertText("Notify activated\n")
                     // myTextView.insertText("----\(num)---------------------\n")
                    //ペアリングデバイスになっていれば、コネクションは問題なく通信できるようになる。
                    //ペアリング要求が表示されると、コネクションはできるが、通信できない。
                       //centralManager.disconnect(from: peripheral)
                }
            }
        }

    }
    
    public func peripheral(_ peripheral: CBPeripheral, didWriteValueForCharacteristics characteristic: CBCharacteristic, error: Error?) {
        //myTextView.insertText("[CBPeripheral3]check\n")
    }
    
    public func peripheral(_ peripheral: CBPeripheral, didUpdateValueFor characteristic: CBCharacteristic, error: Error?) {
        //pheripheralからのUpdateValueの受け取り
        //myTextView.insertText("[CBPeripheralDelegate]didUpdateValue:\(String(describing: characteristic))\n")
        let data: Data = characteristic.value ??  Data(bytes: [0, 0, 0, 0])
        let hexStr = data.map {
            String(format: "%.2hhx", $0)
            }.joined()
        let message: PlaygroundValue = .string(hexStr)
//        for code in hexStr.utf8 {
//
//            myTextView.text = String(code)
//        }
        let result = hexStr.hasPrefix("0103")
        if (result) { // true
            let message: PlaygroundValue = .string(String(hexStr.prefix(6)))
            send(message)
            //myTextView.insertText("[CBPeripheralDelegate]didUpdateValue:\(hexStr.prefix(6))\n")
        }
        else {
            print("不一致")
        }
        //haracteristic.value?[2]がおそらく
        
        send(message)
//        myTextView.text = (message.toString())
        //myTextView.insertText("[CBPeripheralDelegate]didUpdateValue:\(hexStr)\n")
        
        
            //if let value = characteristic.value?.first {
             //   myTextView.insertText("[CBPeripheralDelegate]didUpdateValue:\(String(describing: characteristic.value))\n")
                //myTextView.insertText("[CBPeripheralDelegate]peripheral.name:" + peripheral.name! + "\n")
               // connectionView?.setBatteryLevel(Double(value) / 100, forPeripheral: peripheral)
            //}
        /*
            let val = characteristic.value
            if val != nil {
                vstring = String(data:(val)!, encoding:String.Encoding.utf8)!
                if !vstring.isEmpty  {
                    //print (vstring)
                    myTextView.insertText("[CBPeripheralDelegate]"+vstring+"\n")
                    myTextView.isScrollEnabled = false
                    myTextView.text = myTextView.text + vstring
                    //scroll to bottom
                    myTextView.selectedRange = _NSRange(location: myTextView.text.count, length: 0)
                    myTextView.isScrollEnabled = true
                    let scrollY = myTextView.contentSize.height - myTextView.bounds.height
                    let scrollPoint = CGPoint(x: 0, y: scrollY > 0 ? scrollY: 0)
                    myTextView.setContentOffset(scrollPoint, animated: true)
                }
        } */
        updateWithData(data: characteristic.value!)
    }
    private func updateWithData(data : Data) {
        print(#function)
        
        let reportData = data.withUnsafeBytes {
            [UInt8](UnsafeBufferPointer(start: $0, count: data.count))
        }
        
        /// Format Bitが0 or 1
        if (reportData.first != nil) && 0x01 == 0 {
            print("BPM: \(reportData.last!)")
            myTextView.text = reportData.last?.description
        } else {
            print("BPM : \(CFSwapInt16LittleToHost(UInt16(reportData.last!)))")
        }
    }
}
