//
//  See LICENSE folder for this template’s licensing information.
//
//  Abstract:
//   playground ライブビューとコード間のメッセージハンドリング
//   playground BluetoothによるconnectionViewの表示

import UIKit
import PlaygroundSupport
import CoreBluetooth
import PlaygroundBluetooth

//let BATTERY_MODE = true
//var connectionView:PlaygroundBluetoothConnectionView?

public class MyViewController: UIViewController,PlaygroundLiveViewSafeAreaContainer  {
    
    private var myTextView  = UITextView()
    private var myImageView = UIImageView()
    private var myInputText = UITextView()
    private var myUIButton  = UIButton()
    private var vstring = String()
//
    private var centralManager = PlaygroundBluetoothCentralManager(services:[serviceUuid])
    private var connectionView: PlaygroundBluetoothConnectionView!
    private var myCharacteristic: CBCharacteristic!
    private var myCharacteristicI: CBCharacteristic!
    private var myCharacteristicW: CBCharacteristic!
    private var myCharacteristicN: CBCharacteristic!
    private var myPeripheral: CBPeripheral!
    private var myConnect = false
    
//    var peripheral: CBPeripheral!
    private var LEDUIButton_A  = UIButton()
    private var LEDUIButton_B  = UIButton()
    private var peripheralManager:CBPeripheralManager!
    
    public required init(coder aDecoder: NSCoder) {
        super.init(coder: aDecoder)!
    }
    
    public override init(nibName nibNameOrNil: String?, bundle nibBundleOrNil: Bundle?) {
        super.init(nibName: nibNameOrNil, bundle: nibBundleOrNil)
    }
    
    override public func viewDidLoad() {
        super.viewDidLoad()
        view.backgroundColor = #colorLiteral(red: 0.4745098054, green: 0.8392156959, blue: 0.9764705896, alpha: 1)
        // disable auto layout
        view.translatesAutoresizingMaskIntoConstraints = false

        //セントラルマネージャ
        centralManager.delegate = self
        // コネクションビューの設定connectionView settings
        connectionView = PlaygroundBluetoothConnectionView(centralManager: centralManager)
        connectionView.delegate = self
        connectionView.dataSource = self
        
//        peripheralManager.delegate = self as? CBPeripheralManagerDelegate
        self.peripheralManager = CBPeripheralManager(delegate: self as? CBPeripheralManagerDelegate, queue: nil, options: nil)
        
        // ビューパーツをコンテナ基準で配置
       //テキストビューを配置
        myTextView.font = UIFont.systemFont(ofSize: 20)
        myTextView.isEditable = false
        view.addSubview(myTextView)
        myTextView.backgroundColor  = #colorLiteral(red: 1, green: 1, blue: 1, alpha: 0.5)
        myTextView.layer.cornerRadius = 10
        myTextView.translatesAutoresizingMaskIntoConstraints  = false
        myTextView.topAnchor.constraint(equalTo: liveViewSafeAreaGuide.topAnchor, constant: 90).isActive = true
         myTextView.bottomAnchor.constraint(equalTo: liveViewSafeAreaGuide.bottomAnchor, constant: -90).isActive = true
        myTextView.leadingAnchor.constraint(equalTo: liveViewSafeAreaGuide.leadingAnchor, constant: 20).isActive = true
        myTextView.trailingAnchor.constraint(equalTo: liveViewSafeAreaGuide.trailingAnchor, constant: -20).isActive = true
        
        //ボタンを配置
        myUIButton.isEnabled = true
        myUIButton.backgroundColor  = #colorLiteral(red: 0.8078431487, green: 0.02745098062, blue: 0.3333333433, alpha: 1)
        myUIButton.layer.cornerRadius = 10
        myUIButton.addTarget(self, action: #selector(self.pb), for: .touchUpInside)
        myUIButton.addTarget(self, action: #selector(self.db), for: .touchDown)
        myUIButton.isEnabled = true
        myUIButton.setTitle("▲", for: UIControl.State.normal)
       // view.addSubview(myUIButton)
     //   myUIButton.translatesAutoresizingMaskIntoConstraints  = false
     //   myUIButton.heightAnchor.constraint(equalToConstant: 50.0).isActive = true
      //  myUIButton.widthAnchor.constraint(equalToConstant: 50.0).isActive = true
        //myUIButton.bottomAnchor.constraint(equalTo: liveViewSafeAreaGuide.bottomAnchor, constant: -20).isActive = true
       // myUIButton.trailingAnchor.constraint(equalTo: liveViewSafeAreaGuide.trailingAnchor, constant: -20).isActive = true
        
        //入力ボックスを配置
        myInputText.font = UIFont.systemFont(ofSize: 20)
        myInputText.isEditable = true
        myInputText.translatesAutoresizingMaskIntoConstraints = false
        myInputText.backgroundColor  = #colorLiteral(red: 1, green: 1, blue: 1, alpha: 0.6906035959)
        myInputText.layer.cornerRadius = 10
       // view.addSubview(myInputText)
        //myInputText.heightAnchor.constraint(equalToConstant: 50.0).isActive = true
        //myInputText.leadingAnchor.constraint(equalTo: liveViewSafeAreaGuide.leadingAnchor, constant: 20).isActive = true
        //myInputText.trailingAnchor.constraint(equalTo: myUIButton.leadingAnchor, constant: -10.0).isActive = true
        //myInputText.bottomAnchor.constraint(equalTo: liveViewSafeAreaGuide.bottomAnchor, constant: -20).isActive = true
        
        
        //LEDテスト用のボタンを配置
        LEDUIButton_A.isEnabled = true
        LEDUIButton_A.backgroundColor  = #colorLiteral(red: 0.501960814, green: 0.501960814, blue: 0.501960814, alpha: 1)
        LEDUIButton_A.layer.cornerRadius = 10
        LEDUIButton_A.addTarget(self, action: #selector(self.left), for: .touchDown)
        LEDUIButton_A.isEnabled = true
        LEDUIButton_A.setTitle("◆", for: UIControl.State.normal)
        view.addSubview(LEDUIButton_A)
        LEDUIButton_A.translatesAutoresizingMaskIntoConstraints  = false
        LEDUIButton_A.heightAnchor.constraint(equalToConstant: 80.0).isActive = true
        LEDUIButton_A.widthAnchor.constraint(equalToConstant: 80.0).isActive = true
        LEDUIButton_A.bottomAnchor.constraint(equalTo: liveViewSafeAreaGuide.bottomAnchor, constant: -300).isActive = true
        LEDUIButton_A.trailingAnchor.constraint(equalTo: liveViewSafeAreaGuide.trailingAnchor, constant: -320).isActive = true
        
        LEDUIButton_B.isEnabled = true
        LEDUIButton_B.backgroundColor  = #colorLiteral(red: 0.501960814, green: 0.501960814, blue: 0.501960814, alpha: 1)
        LEDUIButton_B.layer.cornerRadius = 10
        LEDUIButton_B.addTarget(self, action: #selector(self.right), for: .touchDown)
        LEDUIButton_B.isEnabled = true
        LEDUIButton_B.setTitle("◆", for: UIControl.State.normal)
        view.addSubview(LEDUIButton_B)
        LEDUIButton_B.translatesAutoresizingMaskIntoConstraints  = false
        LEDUIButton_B.heightAnchor.constraint(equalToConstant: 80.0).isActive = true
        LEDUIButton_B.widthAnchor.constraint(equalToConstant: 80.0).isActive = true
        LEDUIButton_B.bottomAnchor.constraint(equalTo: liveViewSafeAreaGuide.bottomAnchor, constant: -300).isActive = true
        LEDUIButton_B.trailingAnchor.constraint(equalTo: liveViewSafeAreaGuide.trailingAnchor, constant: -120).isActive = true
        
        
        //BluetoothのconnectionViewを配置
        view.addSubview(connectionView)
        // Position the connection view in the top right corner.
       connectionView.topAnchor.constraint(equalTo: liveViewSafeAreaGuide.topAnchor, constant: 20).isActive = true
       connectionView.trailingAnchor.constraint(equalTo: liveViewSafeAreaGuide.trailingAnchor, constant: -20).isActive = true
    }
    
    override public func viewWillAppear(_ animated: Bool) {
    }
    
    func startAdvertise(data: Data) {
        myPeripheral.writeValue(data, for: myCharacteristicW, type: CBCharacteristicWriteType.withResponse)
    }
    
    @objc func right(){
        send(PlaygroundValue.string("right"))
    }
    
    @objc func left(){
        send(PlaygroundValue.string("left"))
    }
    
    func  red(){
        //これでデータが送れるはず？？
        var test:Data = Data(bytes: [0x01, 0x00, 0x7e, 0x00, 0x00, 0x00,0x00,0x00,0x07,0xFF,0x00,0xFF,0x00,0x01])
        var b:UInt8 = 0x00
        for i in test {
            b = b &+ i
        }
        test.append(b)
        startAdvertise(data: test)
    }
    
    func  blue(){
        //これでデータが送れるはず？？
        var test:Data = Data(bytes: [0x01, 0x00, 0x00, 0x00, 0x00, 0x00,0x7e,0x00,0x07,0xFF,0x00,0xFF,0x00,0x01])
        var b:UInt8 = 0x00
        for i in test {
            b = b &+ i
        }
        test.append(b)
        startAdvertise(data: test)
    }
    @objc func db(){
        myUIButton.layer.shadowOpacity = 0.0
    }
    
    @objc func pb(){
    }
    
}

extension MyViewController: PlaygroundLiveViewMessageHandler {
    //Playgroundページからメッセージを受け取る際の処理。
    public func receive(_ message: PlaygroundValue) {
        if case let .string(text) = message {
            if (text == "atari") {
                blue()
            }
            if (text == "hazure") {
                red()
            }
            //myTextView.insertText("[receive from your code]"+text+"\n")
        }
    }
   //Playgroundページにメッセージを送る際のサンプル。
    public func tapped() {
        let message: PlaygroundValue = .string("Hello!")
        //myTextView.insertText("[send to your code]Hello!\n")
        send(message)
    }
    
}

extension MyViewController: PlaygroundBluetoothConnectionViewDelegate {
    
    public func connectionView(_ connectionView: PlaygroundBluetoothConnectionView, shouldDisplayDiscovered peripheral: CBPeripheral, withAdvertisementData advertisementData: [String : Any]?, rssi: Double) -> Bool {
        return true
    }
    
    public func connectionView(_ connectionView: PlaygroundBluetoothConnectionView, shouldConnectTo peripheral: CBPeripheral, withAdvertisementData advertisementData: [String : Any]?, rssi: Double) -> Bool {
        return true
    }
    
    public func connectionView(_ connectionView: PlaygroundBluetoothConnectionView, willDisconnectFrom peripheral: CBPeripheral) {
    }
    
    public func connectionView(_ connectionView: PlaygroundBluetoothConnectionView, titleFor state: PlaygroundBluetoothConnectionView.State) -> String {
        //Viewのタイトル文字列を返す
        //return "状態"
        let str = "\(state)"
        if(str == "noConnection") {
            return "MESH未接続"
        } else if (str == "selectingPeripherals") {
            return "MESHブロックの選択"
        } else {
            return "\(state)"
        }
    }
    
    public func connectionView(_ connectionView: PlaygroundBluetoothConnectionView, firmwareUpdateInstructionsFor peripheral: CBPeripheral) -> String {
        return #function
    }
}

extension MyViewController: PlaygroundBluetoothConnectionViewDataSource {
    public func connectionView(_ connectionView: PlaygroundBluetoothConnectionView, itemForPeripheral peripheral: CBPeripheral, withAdvertisementData advertisementData: [String : Any]?) ->  PlaygroundBluetoothConnectionView.Item {
        //myTextView.insertText("[connectionView:advertisementData1]\(String(describing: advertisementData))\n")
        //myTextView.insertText("[connectionView:advertisementData2]\(peripheral)\n")
        
        let name = peripheral.name ?? "Unknown" //peripheral.nameがnilのときはnameをUnknownとする。
        var icon = UIImage()
        if name.contains("MESH-100AC") {
            icon = UIImage(named:"MESH-icon/MESH-100AC@2x.png")!
        } else if name.contains("MESH-100LE") {
            icon = UIImage(named:"MESH-icon/MESH-100LE@2x.png")!
        } else if name.contains("MESH-100BU") {
            icon = UIImage(named:"MESH-icon/MESH-100BU@2x.png")!
        } else if name.contains("MESH-100GP") {
            icon = UIImage(named:"MESH-icon/MESH-100GP@2x.png")!
        } else if name.contains("MESH-100PA") {
            icon = UIImage(named:"MESH-icon/MESH-100PA@2x.png")!
        } else if name.contains("MESH-100TH") {
            icon = UIImage(named:"MESH-icon/MESH-100TH@2x.png")!
        }else if name.contains("MESH-100MD") {
            icon = UIImage(named:"MESH-icon/MESH-100MD@2x.png")!
        }else if name.contains("iPhone") {
            icon = UIImage(named:"icon_iphone@2x.png")!
        }else if name.contains("micro:bit") {
                    icon = UIImage(named:"icon_microbit@2x.png")!
        }else {
                    icon = UIImage(named:"icon_Unknown@2x.png")!
        }
        let item = PlaygroundBluetoothConnectionView.Item(name: name, icon: icon, issueIcon: icon)
        return item
    }
}

extension MyViewController: PlaygroundBluetoothCentralManagerDelegate {
    
    public func centralManagerStateDidChange(_ centralManager: PlaygroundBluetoothCentralManager) {
        if centralManager.state == CBManagerState.poweredOff {
           // print("turn on iPad's Bluetooth.")
           // myTextView.insertText("[centralManager]turn on iPad's Bluetooth.\n")
        }
    }
    
    public func centralManager(_ centralManager: PlaygroundBluetoothCentralManager, didDiscover peripheral: CBPeripheral, withAdvertisementData advertisementData: [String : Any]?, rssi: Double) {
      //  myTextView.insertText("[centralManager1]check\n")
    }
    
    public func centralManager(_ centralManager: PlaygroundBluetoothCentralManager, willConnectTo peripheral: CBPeripheral) {
        //print("Connect Start:" + peripheral.name! + "\n")
       // myTextView.insertText("[centralManager]Connect start:" + peripheral.name! + "\n")
        myPeripheral = peripheral
    }
    
    public func centralManager(_ centralManager: PlaygroundBluetoothCentralManager, didConnectTo peripheral: CBPeripheral) {
        //myTextView.insertText("[centralManager]set peripheral delegate\n")
        peripheral.delegate = self
        peripheral.discoverServices([serviceUuid])
    }
    
    public func centralManager(_ centralManager: PlaygroundBluetoothCentralManager, didFailToConnectTo peripheral: CBPeripheral, error: Error?) {
        //myTextView.insertText("[centralManager]fail to connect\n")
    }
    
    public func centralManager(_ centralManager: PlaygroundBluetoothCentralManager, didDisconnectFrom peripheral: CBPeripheral, error: Error?) {
       // myTextView.insertText("[centralManager]disconnected.\n")
        myPeripheral = nil
        myCharacteristic = nil
    }
}

extension MyViewController: CBPeripheralDelegate {
    public func peripheral(_ peripheral: CBPeripheral, didDiscoverServices error: Error?) {
        //サービスが検出された。
        //myTextView.insertText("[CBPeripheralDelegate]\(String(describing: peripheral.services))\n")
        if let service = peripheral.services?.first(where: { $0.uuid == serviceUuid }) {
        //myTextView.insertText("[CBPeripheral1]check2\n")
           // peripheral.discoverCharacteristics([characteristicUuid], for: service)
            peripheral.discoverCharacteristics([characteristicUuidI, characteristicUuidW, characteristicUuidN, characteristicUuidWwo], for: service)
        }
    }
    
    public func peripheral(_ peripheral: CBPeripheral, didDiscoverCharacteristicsFor service: CBService, error: Error?) {
        if error != nil {
            //myTextView.insertText("[DEBUG] error discovering characteristics: \(error)")
            return
        }
        //ペアリング済みでないデバイスの場合にはペアリングアラートを表示
        //
        
            myPeripheral = peripheral
        if let characteristic = service.characteristics?.first(where: { $0.uuid == characteristicUuidI}) {
           //myTextView.insertText("Indicate activation\n")
            myCharacteristicI = characteristic
            if myCharacteristicI.properties.contains(.indicate) {
               // myTextView.insertText("Indicate contained\n")
                peripheral.setNotifyValue(true, for: myCharacteristicI)
            }
           // myTextView.insertText("Indicate activated\n")
            //write activation code
            if let characteristic = service.characteristics?.first(where: { $0.uuid == characteristicUuidW }) {
                myCharacteristicW = characteristic
                if myCharacteristicW.properties.contains(.write) {
                //myTextView.insertText("Write contained\n")
                    let data = Data(bytes: [0x00, 0x02, 0x01, 0x03])
                    myPeripheral.writeValue(data, for: myCharacteristicW, type: CBCharacteristicWriteType.withResponse)
                    //0x00020103を送ると、MESHからペアリング要求がくる。
                    
                }
                //myTextView.insertText("Write activated\n")
                //Notify activation
                if let characteristic = service.characteristics?.first(where: { $0.uuid == characteristicUuidN }) {
                    myCharacteristicN = characteristic
                    if myCharacteristicN.properties.contains(.notify) {
                      //myTextView.insertText("Notify contained\n")
                        peripheral.setNotifyValue(true, for: myCharacteristicN)
                    }
                   // let state = peripheral.state
                    //let num = state.rawValue
                      //myTextView.insertText("Notify activated\n")
                     // myTextView.insertText("----\(num)---------------------\n")
                    //ペアリングデバイスになっていれば、コネクションは問題なく通信できるようになる。
                    //ペアリング要求が表示されると、コネクションはできるが、通信できない。
                       //centralManager.disconnect(from: peripheral)
                }
            }
        }
        

    }
    
    public func peripheral(_ peripheral: CBPeripheral, didWriteValueForCharacteristics characteristic: CBCharacteristic, error: Error?) {
        //myTextView.insertText("[CBPeripheral3]check\n")
    }
    
    public func peripheral(_ peripheral: CBPeripheral, didUpdateValueFor characteristic: CBCharacteristic, error: Error?) {
        //pheripheralからのUpdateValueの受け取り
        
        //myTextView.insertText("[CBPeripheralDelegate]didUpdateValue:\(String(describing: characteristic))\n")
        let data: Data = characteristic.value ??  Data(bytes: [0, 0, 0, 0])
        let hexStr = data.map {
            String(format: "%.2hhx", $0)
            }.joined()
        let message: PlaygroundValue = .string(hexStr)
        send(message)
        //myTextView.insertText("[CBPeripheralDelegate]didUpdateValue:\(hexStr)\n")
        
        
            //if let value = characteristic.value?.first {
             //   myTextView.insertText("[CBPeripheralDelegate]didUpdateValue:\(String(describing: characteristic.value))\n")
                //myTextView.insertText("[CBPeripheralDelegate]peripheral.name:" + peripheral.name! + "\n")
               // connectionView?.setBatteryLevel(Double(value) / 100, forPeripheral: peripheral)
            //}
        /*
            let val = characteristic.value
            if val != nil {
                vstring = String(data:(val)!, encoding:String.Encoding.utf8)!
                if !vstring.isEmpty  {
                    //print (vstring)
                    myTextView.insertText("[CBPeripheralDelegate]"+vstring+"\n")
                    myTextView.isScrollEnabled = false
                    myTextView.text = myTextView.text + vstring
                    //scroll to bottom
                    myTextView.selectedRange = _NSRange(location: myTextView.text.count, length: 0)
                    myTextView.isScrollEnabled = true
                    let scrollY = myTextView.contentSize.height - myTextView.bounds.height
                    let scrollPoint = CGPoint(x: 0, y: scrollY > 0 ? scrollY: 0)
                    myTextView.setContentOffset(scrollPoint, animated: true)
                }
        } */
    }
}
