//
//  See LICENSE folder for this template’s licensing information.
//
//  Abstract:
//   playground ライブビューとコード間のメッセージハンドリング
//   playground BluetoothによるconnectionViewの表示

import UIKit
import PlaygroundSupport
import CoreBluetooth
import PlaygroundBluetooth

//let serviceUuid = CBUUID(string: "72C90001-57A9-4D40-B746-534E22EC9F9E")
//let characteristicUuidI = CBUUID(string: "72C90005-57A9-4D40-B746-534E22EC9F9E")//Indicate
//let characteristicUuidN = CBUUID(string: "72C90003-57A9-4D40-B746-534E22EC9F9E")//Notify
//let characteristicUuidW = CBUUID(string: "72C90004-57A9-4D40-B746-534E22EC9F9E")//Write
//let characteristicUuidWwo = CBUUID(string: "72C90002-57A9-4D40-B746-534E22EC9F9E")//Write w/o response


public class SliderViewController: UIViewController,PlaygroundLiveViewSafeAreaContainer  {

    private var myTextView  = UITextView()
    private var myImageView = UIImageView()
    private var colorView = UIView()
    private var myInputText = UITextView()
    private var myUIButton  = UIButton()
    private var redSlider = UISlider()
    private var  greenSlider = UISlider()
    private var  blueSlider = UISlider()
    private var vstring = String()
    
//
    private var centralManager = PlaygroundBluetoothCentralManager(services:[serviceUuid])
    private var connectionView: PlaygroundBluetoothConnectionView!
    private var myCharacteristic: CBCharacteristic!
    private var myCharacteristicI: CBCharacteristic!
    private var myCharacteristicW: CBCharacteristic!
    private var myCharacteristicN: CBCharacteristic!
    private var myPeripheral: CBPeripheral!
    private var myConnect = false
    
    public required init(coder aDecoder: NSCoder) {
        super.init(coder: aDecoder)!
    }
    
    public override init(nibName nibNameOrNil: String?, bundle nibBundleOrNil: Bundle?) {
        super.init(nibName: nibNameOrNil, bundle: nibBundleOrNil)
    }
    
    override public func viewDidLoad() {
        super.viewDidLoad()
        view.backgroundColor = #colorLiteral(red: 0.4745098054, green: 0.8392156959, blue: 0.9764705896, alpha: 1)
        // disable auto layout
        view.translatesAutoresizingMaskIntoConstraints = false

        //セントラルマネージャ
        centralManager.delegate = self
        // コネクションビューの設定connectionView settings
        connectionView = PlaygroundBluetoothConnectionView(centralManager: centralManager)
        connectionView.delegate = self
        connectionView.dataSource = self
        
        // ビューパーツをコンテナ基準で配置
        //画像ビューを配置
        myImageView = UIImageView(frame: CGRect(x: 0, y: 0, width: 200, height: 200))
        let myImage: UIImage = UIImage(named: "lightImageOff.png")!
        myImageView.image = myImage
     /*   view.addSubview(myImageView)
        myImageView.translatesAutoresizingMaskIntoConstraints  = false
        myImageView.topAnchor.constraint(equalTo: liveViewSafeAreaGuide.topAnchor, constant: 90).isActive = true
        myImageView.bottomAnchor.constraint(equalTo: liveViewSafeAreaGuide.bottomAnchor, constant: -90).isActive = true
        myImageView.leadingAnchor.constraint(equalTo: liveViewSafeAreaGuide.leadingAnchor, constant: 20).isActive = true
        myImageView.trailingAnchor.constraint(equalTo: liveViewSafeAreaGuide.trailingAnchor, constant: -20).isActive = true
 */
        //テキストビューを配置
        myTextView.font = UIFont.systemFont(ofSize: 20)
        myTextView.isEditable = false
        view.addSubview(myTextView)
        myTextView.backgroundColor  = #colorLiteral(red: 1, green: 1, blue: 1, alpha: 0.5)
        myTextView.layer.cornerRadius = 10
        myTextView.translatesAutoresizingMaskIntoConstraints  = false
        myTextView.topAnchor.constraint(equalTo: liveViewSafeAreaGuide.topAnchor, constant: 90).isActive = true
        myTextView.bottomAnchor.constraint(equalTo: liveViewSafeAreaGuide.bottomAnchor, constant: -40).isActive = true
        myTextView.leadingAnchor.constraint(equalTo: liveViewSafeAreaGuide.leadingAnchor, constant: 20).isActive = true
        myTextView.trailingAnchor.constraint(equalTo: liveViewSafeAreaGuide.trailingAnchor, constant: -20).isActive = true
        
        //円形のカラービューを配置
        colorView = UIView(frame: CGRect(x: 0, y: 0, width: 100, height: 100))
        colorView.layer.cornerRadius = 50.0
        let bgColor = UIColor.black
        colorView.backgroundColor = bgColor
        view.addSubview(colorView)
        colorView.translatesAutoresizingMaskIntoConstraints  = false
        colorView.heightAnchor.constraint(equalToConstant: 100.0).isActive = true
        colorView.widthAnchor.constraint(equalToConstant: 100.0).isActive = true
       colorView.centerXAnchor.constraint(equalTo: myTextView.centerXAnchor).isActive = true
        colorView.topAnchor.constraint(equalTo: myTextView.topAnchor, constant: 40).isActive = true

        //赤スライダーを配置
        redSlider.frame = CGRect(x: 32, y: 140, width: UIScreen.main.bounds.size.width-52, height: 10)
        redSlider.minimumValue = 0
        redSlider.maximumValue = 127
        redSlider.value = 0
        redSlider.minimumTrackTintColor = UIColor.red
        // スライダーが変更されたときに呼び出されるメソッドの設定
        redSlider.addTarget(self, action: #selector(changeColorSlider), for: UIControl.Event.valueChanged)
        view.addSubview(redSlider)
        redSlider.tag = 1  // タグを1に設定
        redSlider.translatesAutoresizingMaskIntoConstraints  = false
        redSlider.topAnchor.constraint(equalTo: liveViewSafeAreaGuide.topAnchor, constant: 300).isActive = true
        redSlider.bottomAnchor.constraint(equalTo: liveViewSafeAreaGuide.topAnchor, constant: 340).isActive = true
        redSlider.leadingAnchor.constraint(equalTo: liveViewSafeAreaGuide.leadingAnchor, constant: 40).isActive = true
        redSlider.trailingAnchor.constraint(equalTo: liveViewSafeAreaGuide.trailingAnchor, constant: -40).isActive = true
        //緑スライダーを配置
        greenSlider.frame = CGRect(x: 32, y: 140, width: UIScreen.main.bounds.size.width-52, height: 10)
        greenSlider.minimumValue = 0
        greenSlider.maximumValue = 127
        greenSlider.value = 0
        greenSlider.minimumTrackTintColor = UIColor.green
        // スライダーが変更されたときに呼び出されるメソッドの設定
        greenSlider.addTarget(self, action: #selector(changeColorSlider), for: UIControl.Event.valueChanged)
        view.addSubview(greenSlider)
        greenSlider.tag = 2  // タグを2に設定
        greenSlider.translatesAutoresizingMaskIntoConstraints  = false
        greenSlider.topAnchor.constraint(equalTo: liveViewSafeAreaGuide.topAnchor, constant: 350).isActive = true
        greenSlider.bottomAnchor.constraint(equalTo: liveViewSafeAreaGuide.topAnchor, constant: 390).isActive = true
        greenSlider.leadingAnchor.constraint(equalTo: liveViewSafeAreaGuide.leadingAnchor, constant: 40).isActive = true
        greenSlider.trailingAnchor.constraint(equalTo: liveViewSafeAreaGuide.trailingAnchor, constant: -40).isActive = true
        //青スライダーを配置
        blueSlider.frame = CGRect(x: 32, y: 140, width: UIScreen.main.bounds.size.width-52, height: 10)
        blueSlider.minimumValue = 0
        blueSlider.maximumValue = 127
        blueSlider.value = 0
        blueSlider.minimumTrackTintColor = UIColor.blue
        // スライダーが変更されたときに呼び出されるメソッドの設定
        blueSlider.addTarget(self, action: #selector(changeColorSlider), for: UIControl.Event.valueChanged)
        view.addSubview(blueSlider)
        blueSlider.tag = 3  // タグを3に設定
        blueSlider.translatesAutoresizingMaskIntoConstraints  = false
        blueSlider.topAnchor.constraint(equalTo: liveViewSafeAreaGuide.topAnchor, constant: 400).isActive = true
        blueSlider.bottomAnchor.constraint(equalTo: liveViewSafeAreaGuide.topAnchor, constant: 440).isActive = true
        blueSlider.leadingAnchor.constraint(equalTo: liveViewSafeAreaGuide.leadingAnchor, constant: 40).isActive = true
        blueSlider.trailingAnchor.constraint(equalTo: liveViewSafeAreaGuide.trailingAnchor, constant: -40).isActive = true

        //ボタンを配置
        myUIButton.isEnabled = true
        myUIButton.backgroundColor  = #colorLiteral(red: 0.2549019754, green: 0.2745098174, blue: 0.3019607961, alpha: 1)
        myUIButton.layer.cornerRadius = 10
        myUIButton.addTarget(self, action: #selector(self.pb), for: .touchUpInside)
        //myUIButton.addTarget(self, action: #selector(self.db), for: .touchDown)
        myUIButton.isEnabled = true
        myUIButton.setTitle("MESH LEDの消灯", for: UIControl.State.normal)
        view.addSubview(myUIButton)
        myUIButton.translatesAutoresizingMaskIntoConstraints  = false
        myUIButton.topAnchor.constraint(equalTo: myTextView.bottomAnchor, constant: -60).isActive = true

        myUIButton.heightAnchor.constraint(equalToConstant: 40.0).isActive = true
        myUIButton.widthAnchor.constraint(equalToConstant: 150.0).isActive = true
       myUIButton.centerXAnchor.constraint(equalTo: myTextView.centerXAnchor).isActive = true
//        myUIButton.bottomAnchor.constraint(equalTo: liveViewSafeAreaGuide.bottomAnchor, constant: -20).isActive = true
//        myUIButton.trailingAnchor.constraint(equalTo: liveViewSafeAreaGuide.trailingAnchor, constant: -20).isActive = true

        //入力ボックスを配置
        myInputText.font = UIFont.systemFont(ofSize: 20)
        myInputText.isEditable = true
        myInputText.translatesAutoresizingMaskIntoConstraints = false
        myInputText.backgroundColor  = #colorLiteral(red: 1, green: 1, blue: 1, alpha: 0.6906035959)
        myInputText.layer.cornerRadius = 10
       // view.addSubview(myInputText)
 //       myInputText.heightAnchor.constraint(equalToConstant: 50.0).isActive = true
 //       myInputText.leadingAnchor.constraint(equalTo: liveViewSafeAreaGuide.leadingAnchor, constant: 20).isActive = true
//        myInputText.trailingAnchor.constraint(equalTo: myUIButton.leadingAnchor, constant: -10.0).isActive = true
//        myInputText.bottomAnchor.constraint(equalTo: liveViewSafeAreaGuide.bottomAnchor, constant: -20).isActive = true
        
        //BluetoothのconnectionViewを配置
        view.addSubview(connectionView)
        // Position the connection view in the top right corner.
       connectionView.topAnchor.constraint(equalTo: liveViewSafeAreaGuide.topAnchor, constant: 20).isActive = true
       connectionView.trailingAnchor.constraint(equalTo: liveViewSafeAreaGuide.trailingAnchor, constant: -20).isActive = true
    }
    
    override public func viewWillAppear(_ animated: Bool) {
    }
    
    @objc func db(){
        myUIButton.layer.shadowOpacity = 0.0
    }
    
    @objc func pb(){ //MESH-LEDの消灯
        if myPeripheral != nil && myCharacteristicW != nil {
                let data = Data(bytes: [0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01 ])
                myPeripheral.writeValue(data, for: myCharacteristicW, type: CBCharacteristicWriteType.withResponse)
            }
        }

    
    @objc func changeColorSlider(_ sender: UISlider) {
        // タグで識別
        switch (sender.tag) {
        case 1:
           break
        case 2:
           break
        case 3:
           break
        default:
            break
        }
        // カラーサンプルの色変更
        colorView.backgroundColor = UIColor(red: CGFloat(redSlider.value)/127, green: CGFloat(greenSlider.value)/127, blue: CGFloat(blueSlider.value)/127, alpha: 1.0)
    }
}

extension SliderViewController: PlaygroundLiveViewMessageHandler {
    //Playgroundページからメッセージを受け取る際の処理。
    public func receive(_ message: PlaygroundValue) {
        if case let .string(text) = message {
            if myPeripheral != nil && myCharacteristicW != nil {
                if text.count != 0 {
                    if text == "turn_on" {
                        var data = Data(bytes: [0x01, 0x00])
                        data.append(UInt8(redSlider.value))
                        data.append(0x00)
                        data.append(UInt8(greenSlider.value))
                        data.append(0x00)
                        data.append(UInt8(blueSlider.value))
                        data.append(0x00)
                        data.append(0xff) //点灯時間
                        data.append(0xff)  //点灯サイクル下位
                        data.append(0x00)
                        data.append(0x00)//消灯サイクル下位
                        data.append(0x00)
                        data.append(0x01)//点灯パターン
                        var b:UInt8 = 0x00
                        for i in data {
                            b = b &+ i
                        }
                        data.append(b)
                        myPeripheral.writeValue(data, for: myCharacteristicW, type: CBCharacteristicWriteType.withResponse)
                    } else if text == "turn_off" { //"turn_off"で消灯
                    let data = Data(bytes: [0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01 ])
                    myPeripheral.writeValue(data, for: myCharacteristicW, type: CBCharacteristicWriteType.withResponse)
                } else if text.count >= 8 {//"8桁以上の16進の羅列データ"が送られてきた
                    let redStr = text[text.index(text.startIndex, offsetBy: 0)..<text.index(text.startIndex, offsetBy: 2)]
                    let greenStr = text[text.index(text.startIndex, offsetBy: 2)..<text.index(text.startIndex, offsetBy: 4)]
                    let blueStr = text[text.index(text.startIndex, offsetBy: 4)..<text.index(text.startIndex, offsetBy: 6)]
                    let onoffStr = text[text.index(text.startIndex, offsetBy: 6)..<text.index(text.startIndex, offsetBy: 8)]
                    var data = Data(bytes: [0x01, 0x00])
                    data.append(UInt8(redStr) ?? 0x00)
                    data.append(0x00)
                    data.append(UInt8(greenStr) ?? 0x00)
                    data.append(0x00)
                    data.append(UInt8(blueStr) ?? 0x00)
                    data.append(0x00)
                    data.append(0xff)//点灯時間
                    data.append(UInt8(onoffStr) ?? 0x00)  //点灯サイクル下位
                    data.append(0x00)
                    data.append(0x00)//消灯サイクル下位
                    data.append(0x00)
                    data.append(0x01)//点灯パターン
                    var b:UInt8 = 0x00
                    for i in data {
                        b = b &+ i
                    }
                    data.append(b)
                    myPeripheral.writeValue(data, for: myCharacteristicW, type: CBCharacteristicWriteType.withResponse)
                }
                }
            }
            
            
            //
            
            
            
            
            
        }
    }
   //Playgroundページにメッセージを送る際のサンプル。
    public func tapped() {
        let message: PlaygroundValue = .string("Hello!")
        //myTextView.insertText("[send to your code]Hello!\n")
        send(message)
    }
    
}

extension SliderViewController: PlaygroundBluetoothConnectionViewDelegate {
    
    public func connectionView(_ connectionView: PlaygroundBluetoothConnectionView, shouldDisplayDiscovered peripheral: CBPeripheral, withAdvertisementData advertisementData: [String : Any]?, rssi: Double) -> Bool {
        return true
    }
    
    public func connectionView(_ connectionView: PlaygroundBluetoothConnectionView, shouldConnectTo peripheral: CBPeripheral, withAdvertisementData advertisementData: [String : Any]?, rssi: Double) -> Bool {
        return true
    }
    
    public func connectionView(_ connectionView: PlaygroundBluetoothConnectionView, willDisconnectFrom peripheral: CBPeripheral) {
    }
    
    public func connectionView(_ connectionView: PlaygroundBluetoothConnectionView, titleFor state: PlaygroundBluetoothConnectionView.State) -> String {
        //Viewのタイトル文字列を返す
        //return "状態"
        let str = "\(state)"
        if(str == "noConnection") {
            return "MESH未接続"
        } else if (str == "selectingPeripherals") {
            return "MESHブロックの選択"
        } else {
            return "\(state)"
        }
    }
    
    public func connectionView(_ connectionView: PlaygroundBluetoothConnectionView, firmwareUpdateInstructionsFor peripheral: CBPeripheral) -> String {
        return #function
    }
}

extension SliderViewController: PlaygroundBluetoothConnectionViewDataSource {
    public func connectionView(_ connectionView: PlaygroundBluetoothConnectionView, itemForPeripheral peripheral: CBPeripheral, withAdvertisementData advertisementData: [String : Any]?) ->  PlaygroundBluetoothConnectionView.Item {
        //myTextView.insertText("[connectionView:advertisementData1]\(String(describing: advertisementData))\n")
        //myTextView.insertText("[connectionView:advertisementData2]\(peripheral)\n")

        let name = peripheral.name ?? "Unknown" //peripheral.nameがnilのときはnameをUnknownとする。
        var icon = UIImage()
        if name.contains("MESH-100AC") {
            icon = UIImage(named:"MESH-icon/MESH-100AC@2x.png")!
        } else if name.contains("MESH-100LE") {
            icon = UIImage(named:"MESH-icon/MESH-100LE@2x.png")!
        } else if name.contains("MESH-100BU") {
            icon = UIImage(named:"MESH-icon/MESH-100BU@2x.png")!
        } else if name.contains("MESH-100GP") {
            icon = UIImage(named:"MESH-icon/MESH-100GP@2x.png")!
        } else if name.contains("MESH-100PA") {
            icon = UIImage(named:"MESH-icon/MESH-100PA@2x.png")!
        } else if name.contains("MESH-100TH") {
            icon = UIImage(named:"MESH-icon/MESH-100TH@2x.png")!
        }else if name.contains("MESH-100MD") {
            icon = UIImage(named:"MESH-icon/MESH-100MD@2x.png")!
        }else if name.contains("iPhone") {
            icon = UIImage(named:"icon_iphone@2x.png")!
        }else if name.contains("micro:bit") {
                    icon = UIImage(named:"icon_microbit@2x.png")!
        }else {
                    icon = UIImage(named:"icon_Unknown@2x.png")!
        }
        let item = PlaygroundBluetoothConnectionView.Item(name: name, icon: icon, issueIcon: icon)
        return item
    }
}

extension SliderViewController: PlaygroundBluetoothCentralManagerDelegate {
    
    public func centralManagerStateDidChange(_ centralManager: PlaygroundBluetoothCentralManager) {
        if centralManager.state == CBManagerState.poweredOff {
           // print("turn on iPad's Bluetooth.")
           // myTextView.insertText("[centralManager]turn on iPad's Bluetooth.\n")
        }
    }
    
    public func centralManager(_ centralManager: PlaygroundBluetoothCentralManager, didDiscover peripheral: CBPeripheral, withAdvertisementData advertisementData: [String : Any]?, rssi: Double) {
      //  myTextView.insertText("[centralManager1]check\n")
    }
    
    public func centralManager(_ centralManager: PlaygroundBluetoothCentralManager, willConnectTo peripheral: CBPeripheral) {
        //print("Connect Start:" + peripheral.name! + "\n")
       // myTextView.insertText("[centralManager]Connect start:" + peripheral.name! + "\n")
        myPeripheral = peripheral
    }
    
    public func centralManager(_ centralManager: PlaygroundBluetoothCentralManager, didConnectTo peripheral: CBPeripheral) {
        //myTextView.insertText("[centralManager]set peripheral delegate\n")
        peripheral.delegate = self
        peripheral.discoverServices([serviceUuid])
    }
    
    public func centralManager(_ centralManager: PlaygroundBluetoothCentralManager, didFailToConnectTo peripheral: CBPeripheral, error: Error?) {
        //myTextView.insertText("[centralManager]fail to connect\n")
    }
    
    public func centralManager(_ centralManager: PlaygroundBluetoothCentralManager, didDisconnectFrom peripheral: CBPeripheral, error: Error?) {
       // myTextView.insertText("[centralManager]disconnected.\n")
        myPeripheral = nil
        myCharacteristic = nil
    }
}

extension SliderViewController: CBPeripheralDelegate {
    public func peripheral(_ peripheral: CBPeripheral, didDiscoverServices error: Error?) {
        //サービスが検出された。
        //myTextView.insertText("[CBPeripheralDelegate]\(String(describing: peripheral.services))\n")
        if let service = peripheral.services?.first(where: { $0.uuid == serviceUuid }) {
        //myTextView.insertText("[CBPeripheral1]check2\n")
           // peripheral.discoverCharacteristics([characteristicUuid], for: service)
            peripheral.discoverCharacteristics([characteristicUuidI, characteristicUuidW, characteristicUuidN, characteristicUuidWwo], for: service)
        }
    }
    
    public func peripheral(_ peripheral: CBPeripheral, didDiscoverCharacteristicsFor service: CBService, error: Error?) {
        if error != nil {
            //myTextView.insertText("[DEBUG] error discovering characteristics: \(error)")
            return
        }
        //ペアリング済みでないデバイスの場合にはペアリングアラートを表示
        //
        //myTextView.insertText("[CBPeripheral2]check1\n")
            myPeripheral = peripheral
        if let characteristic = service.characteristics?.first(where: { $0.uuid == characteristicUuidI}) {
           //myTextView.insertText("Indicate activation\n")
            myCharacteristicI = characteristic
            if myCharacteristicI.properties.contains(.indicate) {
               // myTextView.insertText("Indicate contained\n")
                peripheral.setNotifyValue(true, for: myCharacteristicI)
            }
           // myTextView.insertText("Indicate activated\n")
            //write activation code
            if let characteristic = service.characteristics?.first(where: { $0.uuid == characteristicUuidW }) {
                myCharacteristicW = characteristic
                if myCharacteristicW.properties.contains(.write) {
                //myTextView.insertText("Write contained\n")
                    let data = Data(bytes: [0x00, 0x02, 0x01, 0x03])
                    myPeripheral.writeValue(data, for: myCharacteristicW, type: CBCharacteristicWriteType.withResponse)
                    //0x00020103を送ると、MESHからペアリング要求がくる。
                    
                }
                //myTextView.insertText("Write activated\n")
                //Notify activation
                if let characteristic = service.characteristics?.first(where: { $0.uuid == characteristicUuidN }) {
                    myCharacteristicN = characteristic
                    if myCharacteristicN.properties.contains(.notify) {
                      //myTextView.insertText("Notify contained\n")
                        peripheral.setNotifyValue(true, for: myCharacteristicN)
                    }
                   // let state = peripheral.state
                    //let num = state.rawValue
                      //myTextView.insertText("Notify activated\n")
                     // myTextView.insertText("----\(num)---------------------\n")
                    //ペアリングデバイスになっていれば、コネクションは問題なく通信できるようになる。
                    //ペアリング要求が表示されると、コネクションはできるが、通信できない。
                       //centralManager.disconnect(from: peripheral)
                }
            }
        }

    }
    
    public func peripheral(_ peripheral: CBPeripheral, didWriteValueForCharacteristics characteristic: CBCharacteristic, error: Error?) {
        //myTextView.insertText("[CBPeripheral3]check\n")
    }
    
    public func peripheral(_ peripheral: CBPeripheral, didUpdateValueFor characteristic: CBCharacteristic, error: Error?) {
        //pheripheralからのUpdateValueの受け取り
        
        //myTextView.insertText("[CBPeripheralDelegate]didUpdateValue:\(String(describing: characteristic))\n")
        let data: Data = characteristic.value ??  Data(bytes: [0, 0, 0, 0])
        let hexStr = data.map {
            String(format: "%.2hhx", $0)
            }.joined()
        let message: PlaygroundValue = .string(hexStr)
        send(message)
        //myTextView.insertText("[CBPeripheralDelegate]didUpdateValue:\(hexStr)\n")
        
        
            //if let value = characteristic.value?.first {
             //   myTextView.insertText("[CBPeripheralDelegate]didUpdateValue:\(String(describing: characteristic.value))\n")
                //myTextView.insertText("[CBPeripheralDelegate]peripheral.name:" + peripheral.name! + "\n")
               // connectionView?.setBatteryLevel(Double(value) / 100, forPeripheral: peripheral)
            //}
        /*
            let val = characteristic.value
            if val != nil {
                vstring = String(data:(val)!, encoding:String.Encoding.utf8)!
                if !vstring.isEmpty  {
                    //print (vstring)
                    myTextView.insertText("[CBPeripheralDelegate]"+vstring+"\n")
                    myTextView.isScrollEnabled = false
                    myTextView.text = myTextView.text + vstring
                    //scroll to bottom
                    myTextView.selectedRange = _NSRange(location: myTextView.text.count, length: 0)
                    myTextView.isScrollEnabled = true
                    let scrollY = myTextView.contentSize.height - myTextView.bounds.height
                    let scrollPoint = CGPoint(x: 0, y: scrollY > 0 ? scrollY: 0)
                    myTextView.setContentOffset(scrollPoint, animated: true)
                }
        } */
    }
}
