//#-hidden-code
//
//  Contents.swift
//
/*
 Either side of the 5 x 5 LED display, the BBC micro:bit has two buttons, one is labelled **A**, the other **B**.
 
 We can use these buttons to carry out different functions.
 
 Let’s use what we have learned in the previous two lessons to see how the buttons work.
 
 For this exercise you are going to display a text message when button **A** is pressed and display a shape (or *icon*) when button **B** is pressed.
 
 1. In the code below look for the box next to the first appearance of `button` and either type `A` or choose **A** from the completion bar.
 
 2. In the line below this, click in the box that says `Hello World` and write your own short message.
 
 4. Now look for the next appearance of the word `button` and either type `B` or choose **B** from the completion bar.
 
 5. In the line below this, click in the box for the `heart` icon. Choose a different shape if you wish from the completion bar.
 
 6. Run the code. Intially nothing happens other than clearing the screen so that it is blank. The micro:bit is waiting for a *button event* to happen.
 
 7. Tap button **A** to see the text scroll and button **B** to display your chosen icon.
 
 8. Return to your code and change your program to display the text when button **B** is pressed and an icon when button **A** is pressed.
 
 9. Run your code to see what happens.

 */
//#-end-hidden-code
/*:#localized(key: "Page3Narrative")
5 x 5 LED ディスプレイの両側に、BBC micro:bit には 2 つのボタンがあり、1 つは **A**、もう 1 つは **B** とラベル付けされています。
 
 これらのボタンを使用してさまざまな機能を実行できます。
 
 前の 2 つのレッスンで学んだ内容を使用して、ボタンがどのように機能するかを見てみましょう。
 
 この演習では、ボタン **A** が押されたときにテキスト メッセージを表示し、ボタン **B** が押されたときに形状 (または *アイコン*) を表示します。
 
 1. 以下のコードで、最初に表示された「ボタン」の横にあるボックスを探し、「A」と入力するか、補完バーから **A** を選択します。
 
 2. この下の行で、「Hello World」と書かれたボックスをクリックし、独自の短いメッセージを作成します。
 
 4. 次に、「button」という単語が次に出現する箇所を探し、「B」と入力するか、補完バーから **B** を選択します。
 
 5. この下の行で、「ハート」アイコンのボックスをクリックします。必要に応じて、補完バーから別の形状を選択します。
 
 6. コードを実行します。最初は、画面をクリアして空白にする以外は何も起こりません。 micro:bit は *ボタン イベント* が発生するのを待っています。
 
 7. ボタン **A** をタップしてテキスト スクロールを表示し、ボタン **B** をタップして選択したアイコンを表示します。
 
 8. コードに戻り、ボタン **B** が押されたときにテキストが表示され、ボタン **A** が押されたときにアイコンが表示されるようにプログラムを変更します。
 
 9. コードを実行して、何が起こるかを確認します。
*/
//#-hidden-code
import PlaygroundSupport

//#-code-completion(everything, hide)
//#-code-completion(currentmodule, show)
//#-code-completion(identifier, show, A, B)
//#-code-completion(identifier, show, duck, happy, target, chessboard, rabbit, giraffe)

//#-end-hidden-code

clearScreen()
onButtonPressed(./*#-editable-code*/<#T##button##BTMicrobit.Button#>/*#-end-editable-code*/, handler: {
    let textToDisplay = /*#-editable-code text to display*/"Hello World"/*#-end-editable-code*/
    showString(textToDisplay)
})
onButtonPressed(./*#-editable-code*/<#T##button##BTMicrobit.Button#>/*#-end-editable-code*/, handler: {
    let imageToDisplay = iconImage(./*#-editable-code*/heart/*#-end-editable-code*/)
    imageToDisplay.showImage()
})
