//#-hidden-code
//
//  Contents.swift
//
/*
So far we've had fun with the built in images on the micro:bit, and scrolled some text.

Let's try creating our own shapes! To do this, we need to tell the micro:bit which LEDs will be on, and which will be off.

If you run the code below, you'll see it still shows the shape of a heart, but this time rather than using the named `heart` image, we use `X` and `.` characters to represent the LEDs which are either *On* or *Off*.

This is your chance to get creative - what can you draw on the micro:bit's screen? Change the code below to change which LEDs are on or off.

If you have some paper handy why not draw a 5 x 5 grid and see what other shapes you can make in such a small grid.

And here's a challenge: can you add some frames and make this into a small animation?
*/

//#-end-hidden-code
/*:#localized(key: "PageLEDNarrative")
 これまでのところ、micro:bit に組み込まれた画像を楽しんだり、テキストをスクロールしたりしてきました。
  
  自分だけの形を作ってみましょう！これを行うには、どの LED がオンになり、どの LED がオフになるかを micro:bit に伝える必要があります。
  
  以下のコードを実行すると、依然としてハートの形が表示されていることがわかりますが、今回は、名前付きの「ハート」イメージを使用するのではなく、「X」と「.」の文字を使用して LED を表します。 *オン* または *オフ*。
  
  これは創造性を発揮するチャンスです - micro:bit の画面に何を描くことができますか?どの LED がオンまたはオフになるかを変更するには、以下のコードを変更します。
  
  紙が手元にある場合は、5 x 5 のグリッドを描いて、そのような小さなグリッドで他にどのような形状を作成できるかを確認してみてはいかがでしょうか。
  
  ここで課題があります。いくつかのフレームを追加して、これを小さなアニメーションにできますか?
*/

//#-hidden-code
import PlaygroundSupport

//#-code-completion(everything, hide)
//#-code-completion(currentmodule, show)

//#-end-hidden-code
//#-editable-code
let frameOne = MicrobitImage("""
. X . X .
X X X X X
X X X X X
. X X X .
. . X . .
""")
//#-end-editable-code
frameOne.showImage()
