//#-hidden-code
//
//  Contents.swift
//
/*
 Perhaps the most noticeable feature of the BBC micro:bit is its 5 x 5 LED display.
 You can write programs to turn on each individual LED.
 Let's look at how to do this by firstly learning how to display text on the micro:bit. The text is displayed in two ways, depending on how many letters there are.
 
 1. Run the code below and notice what happens.
 2. Change the letter ‘M’ with any other SINGLE letter.
 3. Run the code again.
 4. Notice that when the micro:bit displays ONE letter it remains constantly.
 5. Now replace the single letter with a phrase of your choice – for example `Hello World`.
 6. Notice now that when more than one letter is shown it scrolls across the micro:bit one letter at a time.
 
 This activity is an excellent way to use the micro:bit as a name badge. See if you can think of any other ways in which scrolling text could be usefully applied.
 */
//#-end-hidden-code

/*:#localized(key: "Page1Narative")
 おそらく、BBC micro:bit の最も注目すべき機能は、その 5 x 5 LED ディスプレイです。
  個々の LED を点灯するプログラムを作成できます。
  まず、micro:bit にテキストを表示する方法を学び、これを行う方法を見てみましょう。テキストは文字数に応じて 2 つの方法で表示されます。
 1. 以下のコードを実行して、何が起こるか確認してください。
  2. 文字「M」を他の単一文字に変更します。
  3. コードを再度実行します。
  4. micro:bit が 1 つの文字を表示すると、それが常に表示されたままになることに注意してください。
  5. 次に、その 1 文字を任意のフレーズに置き換えます (例: 「Hello World」)。
  6. 複数の文字が表示されている場合、micro:bit 上で一度に 1 文字ずつスクロールすることに注目してください。
  
  このアクティビティは、micro:bit を名札として使用する優れた方法です。スクロール テキストを効果的に適用できる他の方法がないか考えてみましょう。
 
 */

//#-hidden-code
import PlaygroundSupport

//#-code-completion(everything, hide)
//#-code-completion(currentmodule, show)
//#-code-completion(identifier, show, displayText(_:))

//#-end-hidden-code
let textToDisplay = /*#-editable-code text to display*/"M"/*#-end-editable-code*/
showString(textToDisplay)
