//#-hidden-code
//
//  Contents.swift
//
/*
 As you have seen, the LEDs on the BBC micro:bit can be turned on to display text.
 
 In the previous exercise we displayed letters on the screen. But what if we want to display shapes other than letters?
 
 The micro:bit can also show *images*, where each of the LEDs is on or off to make a shape.
 
 Let's try this out.
 
 1. Run the code below.
 
 2. Notice that the micro:bit displays a *heart* shape.
 
 3. For this exercise some images have been created for you. Click on the text `heart` in the `iconImage` function and you will see a list of 6 other images that can be displayed in the completion bar on the keyboard.
 
 4. Select an image from the list.
 
 5. Run your code again.
 
 6. Repeat steps 4 and 5 until you have tried each different shape.
 
 Was it obvious to you what each shape was supposed to represent?
 
 Once you get the hang of using the small space, you can make lots of different shapes and stories with just the micro:bit's display. For example, once you learn more about the micro:bit, it would be possible to write a program to display a heart every time you took a step, or tell an interactive story.
 */
//#-end-hidden-code
/*:#localized(key: "Page2Narrative")
 ご覧のとおり、BBC micro:bit の LED をオンにしてテキストを表示できます。
前の演習では、画面上に文字を表示しました。しかし、文字以外の図形を表示したい場合はどうすればよいでしょうか?
  micro:bit は、各 LED がオンまたはオフになって形状を作成する *画像* を表示することもできます。
 
 これを試してみましょう。
  
  1. 以下のコードを実行します。
  
  2. micro:bit に *ハート* の形が表示されることに注目してください。
  
  3. この演習のために、いくつかのイメージが作成されました。 「iconImage」関数の「ハート」というテキストをクリックすると、キーボードの補完バーに表示できる他の 6 つの画像のリストが表示されます。
  
  4. リストから画像を選択します。
  
  5. コードを再度実行します。
  
  6. それぞれの異なる形状を試し終わるまで、ステップ 4 と 5 を繰り返します。
 
 それぞれの形が何を表しているかは明らかでしたか?
  
  小さなスペースの使い方に慣れれば、micro:bit のディスプレイだけでさまざまな形やストーリーを作ることができます。たとえば、micro:bit について詳しく学べば、一歩踏み出すたびにハートを表示したり、インタラクティブなストーリーを伝えるプログラムを書くことが可能になります。
*/
//#-hidden-code
import PlaygroundSupport

//#-code-completion(everything, hide)
//#-code-completion(currentmodule, show)
//#-code-completion(identifier, show, duck, happy, target, chessboard, rabbit, giraffe)

//#-end-hidden-code
let imageToDisplay = iconImage(./*#-editable-code icon name*/heart/*#-end-editable-code*/)
imageToDisplay.showImage()
