//#-hidden-code
//
//  Contents.swift
//
/*
As you have discovered, despite its small size, the micro:bit is packed full of features and sensors and there are still more to learn about.
 
 The micro:bit is able to read the temperature of its surroundings. The temperature provided is actually the temperature of the CPU. As the processor generally runs cold the temperature is a good approximation of the ambient temperature. We can use this to create a simple thermometer. This activity cannot be performed just using the mimic on the iPad.
 
 On the screen opposite – you can see the temperature of the micro:bit being displayed.
 
 Look at the code below. The code has already been written to detect the temperature in degrees centigrade. The first function sets how often the temperature will be read, in this instance the value of 5000 means 5 seconds.
 
 The second function is a *handler* that is called every 5 seconds with an update of the temperature. The temperature is returned in Celsius / ºC. The temperature is then converted to an `Int` and shown on the LED display.
 
 1. Run the code.
 
 2. Look at the display on your micro:bit. You should see a number being scrolled that is the temperature in ºC of the CPU.
 
 3. Place the micro:bit in the palm of your hand and cup your other hand over it. Hold it like this for 2-3 minutes. Alternatively hold it near a heat source like a radiator.
 
 4. Uncup your hands and look at the display, you should see that the number being displayed has changed as the temperature has risen.
 
 5. If the temperature has risen, keep watching the display and you should see the number drop down to its original value.
 
 6. All the code below can be edited. Edit the code to convert the temperature in ºC to Fahrenheit and display that instead.
 
 The conversion is F = C * 9 / 5 + 32
 */
//#-end-hidden-code
/*:#localized(key: "Page7Narrative")
ご覧のとおり、その小さいサイズにもかかわらず、micro:bit には多くの機能とセンサーが詰め込まれており、まだまだ学ぶべきことがたくさんあります。
 
 micro:bit は周囲の温度を読み取ることができます。提供される温度は実際には CPU の温度です。プロセッサーは通常、低温で動作するため、温度は周囲温度の適切な近似値となります。これを使用して簡単な温度計を作成できます。このアクティビティは、iPad のミミックを使用するだけでは実行できません。
 
 反対側の画面には、micro:bit の温度が表示されています。
 
 以下のコードを見てください。温度を摂氏で検出するコードはすでに書かれています。最初の関数は、温度を読み取る頻度を設定します。この例では、値 5000 は 5 秒を意味します。
 
 2 番目の関数は、温度の更新とともに 5 秒ごとに呼び出される *ハンドラー* です。温度は摂氏/℃で返されます。次に、温度は「Int」に変換され、LED ディスプレイに表示されます。
 
 1. コードを実行します。
 
 2. micro:bit のディスプレイを見てください。 CPU の温度 (℃) を示す数値がスクロールされているのが表示されます。
 
 3. micro:bit を手のひらに置き、もう一方の手をその上に置きます。このまま2〜3分間保持します。あるいは、ラジエーターなどの熱源の近くに持ってください。
 
 4. 手を外し、ディスプレイを見ると、温度の上昇に応じて表示されている数値が変化していることがわかります。
 
 5. 温度が上昇した場合は、ディスプレイを観察し続けると、数値が元の値に下がるのがわかります。
 
 6. 以下のコードはすべて編集できます。コードを編集して、温度を °C 単位で華氏単位に変換し、代わりにそれを表示します。
 
 変換は F = C * 9 / 5 + 32 です。
*/
//#-hidden-code
import PlaygroundSupport

//#-code-completion(everything, hide)
//#-code-completion(currentmodule, show)
//#-code-completion(identifier, show, ., showImage(), .duck, .sword, .chessboard, .target)

//#-end-hidden-code
//#-editable-code
clearScreen()

setTemperaturePeriod(5000, handler: {(period: Int?) in
    let periodinMS = period
})

onTemperature({(temperature: Double) in
    let celsius = temperature
    showNumber(Int(celsius))
})

//#-end-editable-code
