//#-hidden-code
//
//  See LICENSE folder for this template’s licensing information.
//
//  Abstract:
//  The Swift file containing the source code edited by the user of this playground book.
//
//#-end-hidden-code
/*: some text
 ## SQLを学ぶ
 　SQL構文を入力して実行できます。
 ---
 * Important:
　ビュー側でデータベースの操作をするためには、最初に「コードを実行」してください。データベースの保存先をビューに知らせるために必要な操作です。
 */
//#-code-completion(everything, hide)
//#-editable-code
//プログラムはここからです。

import PlaygroundSupport
import Foundation

func sendDatabasePath(_ path: String) {
    if let proxy = PlaygroundPage.current.liveView as? PlaygroundRemoteLiveViewProxy {
        let message: PlaygroundValue = .dictionary(["dbPath": .string(path)])
        proxy.send(message)
    }
}

// データベースファイルのパスを取得（ユーザー側はファイル名決定だけ）
let fileURL = try! FileManager.default
    .url(for: .documentDirectory, in: .userDomainMask, appropriateFor: nil, create: true)
    .appendingPathComponent("Sample.sqlite")

// LiveView にファイルパスを送信
sendDatabasePath(fileURL.path)

/*サンプル
 CREATE TABLE fruits (
     id INTEGER PRIMARY KEY AUTOINCREMENT,
     name TEXT NOT NULL,
     color TEXT,
     price_per_kg INTEGER,
     origin TEXT
 );
 
 DROP TABLE IF EXISTS fruits;
 
 INSERT INTO fruits (name, color, price_per_kg, origin)
 VALUES
     ('りんご', '赤', 300, '青森'),
     ('バナナ', '黄色', 150, 'フィリピン'),
     ('みかん', 'オレンジ', 200, '和歌山');
 
 */

//#-end-editable-code
