//#-hidden-code
//
//  See LICENSE folder for this template’s licensing information.
//
//  Abstract:
//  The Swift file containing the source code edited by the user of this playground book.
//
import PlaygroundSupport
import Foundation
import Network
import UIKit

let page = PlaygroundPage.current
page.needsIndefiniteExecution = false

func sendMessage(_ message: String) {
    if let proxy1 = page.liveView as? PlaygroundRemoteLiveViewProxy {
        let message: PlaygroundValue = .string("message " + message)
        proxy1.send(message)
    }
}

//#-end-hidden-code
/*: some text
##  📖最初のWebページ
Webページを作ってみよう！\
Webページは、HTML(Hyper Text Markup Language)で記述された文字列を解釈してブラウザの画面に表示する仕組みです。\
この教材では、htmlText変数にHTMLコードを代入して、webビューに表示するSwiftの仕組みを使っていますが、本来はHTMLコードを単独のファイルに記述します。
 
 * Note:
HTMLは、タグと呼ばれる括弧で括ったコードを定義するものです。文字をHTMLの規約に合わせてタグで囲む事をマークアップと呼びます。\
例えば、HTMLの解釈の解釈の始めと終わりは&lt;html&gt;&lt;/html&gt;の間に記述するルールです。そして、画面に表示される部分は&lt;body&gt;タグで、タイトル文字列や、ページの定義などは&lt;head&gt;タグで囲むルールになっています。\
以下のコードを実際に実行して見たら、次に<title>タグの内容、&lt;h1&gt;タグの内容を変更して実行して見てください。画面の表示が変わる事を確認する事が大切です。
 ---
 * Callout(このページで初めて使用するタグ):
 **&lt;!DOCTYPE html&gt;**\
 文書がHTMLドキュメントである事を示すタグで、ページの先頭に記述します。\
 **&lt;html&gt;**\
 HTML全体を囲むタグです。\
 **&lt;head&gt;**\
 ページのタイトルなど、ページ全体の設定部分を囲むタグです。\
 **&lt;title&gt;**\
 Webページのタイトルを定義するタグです。\
 **&lt;body&gt;**\
 実際にブラウザに表示するコンテンツを含める部分を囲むタグです。\
 **&lt;h1&gt;〜&lt;h6&gt;**\
 見出しを定義するタグです。\
 **&lt;p&gt;**\
 段落を定義するタグです。
*/
//#-code-completion(everything, hide)
let htmlText = """
//#-editable-code
<!DOCTYPE html>
<html>
<head>
    <title>タイトルです</title>
</head>
<body>
    <h1>こんにちは！</h1>
    <h2>このページは、HTMLを学習するためのものです。</h2>
</body>
</html>
//#-end-editable-code
"""
//#-hidden-code
sendMessage("1,1,①-😊実行しました。")
//assessmentStatusを設定すると、実行が止まるので、必要な処理は全て済ませる。
if( PlaygroundPage.current.assessmentStatus == nil ){
    PlaygroundPage.current.assessmentStatus = .pass(message: "😊実行しました。")
}
//#-end-hidden-code
