//#-hidden-code
//
//  See LICENSE folder for this template’s licensing information.
//
//  Abstract:
//  The Swift file containing the source code edited by the user of this playground book.
//
import PlaygroundSupport
import Foundation
import Network
import UIKit

let page = PlaygroundPage.current
page.needsIndefiniteExecution = false

func sendMessage(_ message: String) {
    if let proxy1 = page.liveView as? PlaygroundRemoteLiveViewProxy {
        let message: PlaygroundValue = .string("message " + message)
        proxy1.send(message)
    }
}

//#-end-hidden-code
/*: some text
##  📖写真を表示
Webページをに写真を表示する方法\
写真（画像データ）は、jpeg形式やpng形式など、別のファイルとして用意し、そのファイルを<img>タグを使って指定する事で、画面に表示することができます。\
このページには、dog.jpgとneko.jpgの画像ファイルが用意されています。
 * Important:
画像は本ブック内でのみ使用し、他では使用しないでください。このページの画像はPexelsから提供されています。
*/
//#-code-completion(everything, hide)
let htmlText = """
//#-editable-code
<html>
<head>
    <title>タイトルです</title>
</head>
<body>
    <h1>こんにちは！</h1>
    <h2>この画像は犬の写真です。</h2>
    <hr>
    <p><img src="dog.jpg"></p>
</body>
</html>
//#-end-editable-code
"""
//#-hidden-code
sendMessage("2,1,②-😊実行しました。")
//assessmentStatusを設定すると、実行が止まるので、必要な処理は全て済ませる。
if( PlaygroundPage.current.assessmentStatus == nil ){
    PlaygroundPage.current.assessmentStatus = .pass(message: "😊実行しました。")
}
//#-end-hidden-code
