import UIKit

protocol TablePickerViewControllerDelegate: AnyObject {
    func didSelectNumber(_ number: Int)
}

class TablePickerViewController: UITableViewController {
    
    weak var delegate: TablePickerViewControllerDelegate?
    
    override func viewDidLoad() {
        super.viewDidLoad()
        
        tableView.dataSource = self
        tableView.delegate = self
    }
}

extension TablePickerViewController {
    override func tableView(_ tableView: UITableView, numberOfRowsInSection section: Int) -> Int {
        return 40
    }
    
    override func tableView(_ tableView: UITableView, cellForRowAt indexPath: IndexPath) -> UITableViewCell {
        let cell = UITableViewCell(style: .default, reuseIdentifier: nil)
        cell.textLabel?.text = String(indexPath.row + 1)
        cell.textLabel?.textAlignment = .center // 中央揃えに設定
        return cell
    }
    
    override func tableView(_ tableView: UITableView, didSelectRowAt indexPath: IndexPath) {
        delegate?.didSelectNumber(indexPath.row + 1)
        presentingViewController?.dismiss(animated: true, completion: nil)
    }
}
